/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.exceptions.OperationNotAllowedEx;
import org.fao.geonet.exceptions.UnAuthorizedException;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;

@Controller
@RequestMapping(value={"/{portal}"})
public class AtomPredefinedFeed {
    @RequestMapping(value={"/atom/describe/service"})
    @ResponseBody
    public HttpEntity<byte[]> localServiceDescribe(@RequestParam(value="uuid") String uuid, @RequestParam(value="language", required=false) String language, NativeWebRequest webRequest) throws Exception {
        ServiceContext context = this.createServiceContext("eng", (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"INSPIRE is disabled");
            throw new OperationNotAllowedEx("INSPIRE option is not enabled on this catalog.");
        }
        Element feed = this.getServiceFeed(context, uuid, language);
        return this.writeOutResponse(Xml.getString((Element)feed), "application", "atom+xml");
    }

    @RequestMapping(value={"/atom/describe/dataset"})
    @ResponseBody
    public HttpEntity<byte[]> localDatasetDescribe(@RequestParam(value="spatial_dataset_identifier_code") String spIdentifier, @RequestParam(value="spatial_dataset_identifier_namespace", required=false) String spNamespace, @RequestParam(value="language", required=false) String language, @RequestParam(value="q", required=false) String searchTerms, NativeWebRequest webRequest) throws Exception {
        ServiceContext context = this.createServiceContext("eng", (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"INSPIRE is disabled");
            throw new OperationNotAllowedEx("INSPIRE option is not enabled on this catalog.");
        }
        Map<String, Object> params = this.getDefaultXSLParams(sm, context, XslUtil.twoCharLangCode((String)context.getLanguage()));
        if (StringUtils.isNotBlank((String)searchTerms)) {
            params.put("searchTerms", searchTerms.toLowerCase());
        }
        Element feed = InspireAtomUtil.getDatasetFeed(context, spIdentifier, spNamespace, params, language);
        return this.writeOutResponse(Xml.getString((Element)feed), "application", "atom+xml");
    }

    private Element getServiceFeed(ServiceContext context, String uuid, String language) throws Exception {
        Log.debug((String)"geonetwork.atom", (Object)("Processing service feed  ( uuid : " + uuid + " )"));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        String id = dm.getMetadataId(uuid);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(uuid);
        }
        try {
            Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        }
        catch (Exception e) {
            throw new UnAuthorizedException("Access denied to metadata " + id, (Object)e);
        }
        Element md = dm.getMetadata(id);
        String schema = dm.getMetadataSchema(id);
        if (!InspireAtomUtil.isServiceMetadata(dm, schema, md)) {
            throw new ResourceNotFoundException("No service metadata found with uuid:" + uuid);
        }
        String defaultLanguage = dm.extractDefaultLanguage(schema, md);
        String requestedLanguage = StringUtils.isNotBlank((String)language) ? language : XslUtil.twoCharLangCode((String)defaultLanguage);
        Element inputDoc = InspireAtomUtil.prepareServiceFeedEltBeforeTransform(schema, md, dm);
        Map<String, Object> params = this.getDefaultXSLParams(sm, context, requestedLanguage);
        return InspireAtomUtil.convertDatasetMdToAtom("iso19139", inputDoc, dm, params);
    }

    private Map<String, Object> getDefaultXSLParams(SettingManager settingManager, ServiceContext context, String requestedLanguage) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isLocal", true);
        params.put("inspire", ((SettingManager)context.getBean(SettingManager.class)).getValue("system/inspire/enable"));
        params.put("thesauriDir", ((GeonetworkDataDirectory)context.getApplicationContext().getBean(GeonetworkDataDirectory.class)).getThesauriDir().toAbsolutePath().toString());
        params.put("requestedLanguage", requestedLanguage);
        params.put("baseUrl", settingManager.getBaseURL());
        params.put("nodeUrl", settingManager.getNodeURL());
        params.put("opensearchUrlSuffix", "opensearch");
        params.put("atomDescribeServiceUrlSuffix", "atom/describe/service");
        params.put("atomDescribeDatasetUrlSuffix", "atom/describe/dataset");
        params.put("atomDownloadDatasetUrlSuffix", "atom/download/dataset");
        params.put("nodeName", ((NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class)).getId());
        return params;
    }

    private ServiceContext createServiceContext(String lang, HttpServletRequest request) {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        return serviceManager.createServiceContext("atom.service", lang, request);
    }

    private HttpEntity<byte[]> writeOutResponse(String content, String contentType, String contentSubType) throws Exception {
        byte[] documentBody = content.getBytes(Constants.ENCODING);
        HttpHeaders header = new HttpHeaders();
        header.setContentType(new MediaType(contentType, contentSubType, Charset.forName(Constants.ENCODING)));
        header.setContentLength((long)documentBody.length);
        return new HttpEntity((Object)documentBody, (MultiValueMap)header);
    }

    @RequestMapping(value={"/atom/download/dataset"})
    @ResponseBody
    public HttpEntity<byte[]> localDatasetDownload(@RequestParam(value="spatial_dataset_identifier_code") String spIdentifier, @RequestParam(value="spatial_dataset_identifier_namespace", required=false) String spNamespace, @RequestParam(value="crs", required=false) String crs, @RequestParam(value="language", required=false) String language, @RequestParam(value="q", required=false) String searchTerms, NativeWebRequest webRequest) throws Exception {
        ServiceContext context = this.createServiceContext("eng", (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"INSPIRE is disabled");
            throw new OperationNotAllowedEx("INSPIRE option is not enabled on this catalog.");
        }
        Map<String, Object> params = this.getDefaultXSLParams(sm, context, context.getLanguage());
        if (StringUtils.isNotBlank((String)crs)) {
            crs = URLDecoder.decode(crs, Constants.ENCODING);
            params.put("requestedCrs", crs);
        }
        if (StringUtils.isNotBlank((String)searchTerms)) {
            params.put("searchTerms", searchTerms.toLowerCase());
        }
        Element feed = InspireAtomUtil.getDatasetFeed(context, spIdentifier, spNamespace, params, language);
        Map<Object, Object> crsCounts = new HashMap();
        Namespace ns = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
        if (crs != null) {
            crsCounts = this.countDatasetsForCrs(feed, crs, ns);
        } else {
            List entries = feed.getChildren("entry", ns);
            if (entries.size() == 1) {
                crsCounts.put(1, entries.get(0));
            }
        }
        int downloadCount = crsCounts.size() > 0 ? (Integer)crsCounts.keySet().iterator().next() : 0;
        Element selectedEntry = (Element)crsCounts.get(downloadCount);
        if (downloadCount == 0) {
            throw new Exception("No downloads available for dataset (spatial_dataset_identifier_code: " + spIdentifier + ", spatial_dataset_identifier_namespace: " + spNamespace + ", crs: " + crs + ", searchTerms: " + searchTerms + ")");
        }
        if (downloadCount == 1) {
            String type = null;
            Element link = selectedEntry.getChild("link", ns);
            if (link != null) {
                type = link.getAttributeValue("type");
            }
            HttpServletResponse nativeRes = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            nativeRes.setStatus(301);
            return this.redirectResponse(selectedEntry.getChildText("id", ns));
        }
        InspireAtomUtil.filterDatasetFeedByCrs(feed, crs);
        return this.writeOutResponse(Xml.getString((Element)feed), "application", "atom+xml");
    }

    private HttpEntity<byte[]> redirectResponse(String location) throws Exception {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(new MediaType("text", "plain", Charset.forName(Constants.ENCODING)));
        header.setContentLength(0L);
        header.setLocation(new URI(location));
        return new HttpEntity((MultiValueMap)header);
    }

    private Map<Integer, Element> countDatasetsForCrs(Element datasetAtomFeed, String datasetCrs, Namespace ns) {
        int downloadCount = 0;
        HashMap<Integer, Element> entryMap = new HashMap<Integer, Element>();
        Element selectedEntry = null;
        for (Element entry : datasetAtomFeed.getChildren("entry", ns)) {
            String term;
            Element category = entry.getChild("category", ns);
            if (category == null || !datasetCrs.equals(term = category.getAttributeValue("term"))) continue;
            selectedEntry = entry;
            ++downloadCount;
        }
        entryMap.put(downloadCount, selectedEntry);
        return entryMap;
    }

    @RequestMapping(value={"/opensearch/OpenSearchDescription.xml"})
    @ResponseBody
    public HttpEntity<byte[]> localOpenSearchDescription(@RequestParam(value="uuid") String uuid, @RequestParam(value="language", required=false) String language, NativeWebRequest webRequest) throws Exception {
        ServiceContext context = this.createServiceContext("eng", (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"INSPIRE is disabled");
            throw new OperationNotAllowedEx("INSPIRE option is not enabled on this catalog.");
        }
        Element description = this.getOpenSearchDescription(context, uuid);
        return this.writeOutResponse(Xml.getString((Element)description), "application", "opensearchdescription+xml");
    }

    private Element getOpenSearchDescription(ServiceContext context, String uuid) throws Exception {
        Log.debug((String)"geonetwork.atom", (Object)("Processing openseachdescription  ( uuid : " + uuid + " )"));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        String id = dm.getMetadataId(uuid);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(uuid);
        }
        try {
            Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        }
        catch (Exception e) {
            throw new UnAuthorizedException("Access denied to metadata " + id, (Object)e);
        }
        Element md = dm.getMetadata(id);
        String schema = dm.getMetadataSchema(id);
        if (!InspireAtomUtil.isServiceMetadata(dm, schema, md)) {
            throw new ResourceNotFoundException("No service metadata found with uuid:" + uuid);
        }
        String defaultLanguage = dm.extractDefaultLanguage(schema, md);
        Map<String, Object> params = this.getDefaultXSLParams(sm, context, XslUtil.twoCharLangCode((String)defaultLanguage));
        Element inputDoc = InspireAtomUtil.prepareOpenSearchDescriptionEltBeforeTransform(context, params, uuid, schema, InspireAtomUtil.convertDatasetMdToAtom("iso19139", InspireAtomUtil.prepareServiceFeedEltBeforeTransform(schema, md, dm), dm, params), defaultLanguage, dm);
        return InspireAtomUtil.convertServiceMdToOpenSearchDescription(context, inputDoc, params);
    }
}

