/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.filter.v2_0.FESConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.jdom.Element;
import org.opengis.filter.Filter;
import org.xml.sax.SAXException;

public class FilterParser {
    private static final Configuration FILTER_1_0_0 = new org.geotools.filter.v1_0.OGCConfiguration();
    private static final Configuration FILTER_1_1_0 = new OGCConfiguration();
    private static final Configuration FILTER_2_0_0 = new FESConfiguration();

    private static Parser createFilterParser(String filterVersion) {
        Configuration config;
        if (filterVersion.equals("1.0.0")) {
            config = FILTER_1_0_0;
        } else if (filterVersion.equals("2.0.0")) {
            config = FILTER_2_0_0;
        } else if (filterVersion.equals("1.1.0")) {
            config = FILTER_1_1_0;
        } else {
            throw new IllegalArgumentException("UnsupportFilterVersion: " + filterVersion);
        }
        return new Parser(config);
    }

    public static Filter parseFilter(Element xml, String filterVersion) {
        if (xml == null) {
            return null;
        }
        return FilterParser.parseFilter(Xml.getString((Element)xml), filterVersion);
    }

    public static Filter parseFilter(String string, String filterVersion) {
        if (string == null) {
            return null;
        }
        Parser parser = FilterParser.createFilterParser(filterVersion);
        parser.setValidating(true);
        parser.setFailOnValidationError(true);
        try {
            Object parseResult = parser.parse((Reader)new StringReader(string));
            if (parseResult instanceof Filter) {
                return (Filter)parseResult;
            }
            return null;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Log.error((String)"geonetwork.csw.search", (Object)"Errors occurred when trying to parse a filter", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

