/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.EhcacheRegionFactory;
import org.hibernate.cache.ehcache.internal.HibernateEhcacheUtils;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.jboss.logging.Logger;

public class SingletonEhcacheRegionFactory
extends EhcacheRegionFactory {
    private static final Logger LOG = Logger.getLogger(SingletonEhcacheRegionFactory.class);
    private static final AtomicInteger REFERENCE_COUNT = new AtomicInteger();

    @Override
    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        try {
            URL url;
            String configurationResourceName = (String)((ConfigurationService)this.getOptions().getServiceRegistry().getService(ConfigurationService.class)).getSetting("net.sf.ehcache.configurationResourceName", value -> value == null ? null : value.toString());
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                try {
                    REFERENCE_COUNT.incrementAndGet();
                    return CacheManager.create();
                }
                catch (RuntimeException e) {
                    REFERENCE_COUNT.decrementAndGet();
                    throw e;
                }
            }
            try {
                url = new URL(configurationResourceName);
            }
            catch (MalformedURLException e) {
                if (!configurationResourceName.startsWith("/")) {
                    configurationResourceName = "/" + configurationResourceName;
                    LOG.debugf("prepending / to %s. It should be placed in the root of the classpath rather than in a package.", (Object)configurationResourceName);
                }
                url = this.loadResource(configurationResourceName);
            }
            try {
                REFERENCE_COUNT.incrementAndGet();
                Configuration config = HibernateEhcacheUtils.loadAndCorrectConfiguration(url);
                HibernateEhcacheUtils.setCacheManagerNameIfNeeded(settings, config, properties);
                return CacheManager.create((Configuration)config);
            }
            catch (RuntimeException e) {
                REFERENCE_COUNT.decrementAndGet();
                throw e;
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void releaseFromUse() {
        if (REFERENCE_COUNT.decrementAndGet() == 0) {
            super.releaseFromUse();
        }
    }
}

