/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.configuration.provider.db;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;
import org.jzkit.ServiceDirectory.AttributeSetDBO;
import org.jzkit.ServiceDirectory.CollectionDescriptionDBO;
import org.jzkit.ServiceDirectory.CollectionInfoTypeDBO;
import org.jzkit.ServiceDirectory.InformationLandscapeDBO;
import org.jzkit.ServiceDirectory.SearchServiceDescriptionDBO;
import org.jzkit.configuration.api.AppSettingDBO;
import org.jzkit.configuration.api.CollectionDefDTO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.configuration.api.RecordMappingInformationDBO;
import org.jzkit.configuration.api.RecordTransformerTypeInformationDBO;
import org.jzkit.configuration.api.SearchServiceDTO;
import org.jzkit.search.provider.iface.JZKitPluginMetadata;
import org.jzkit.search.util.Profile.CrosswalkDBO;
import org.jzkit.search.util.Profile.ProfileDBO;
import org.jzkit.search.util.QueryBuilder.QueryBuilder;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.springframework.context.ApplicationContext;

public class DbConfigurationProvider
implements Configuration {
    private SessionFactory sf = null;
    private org.hibernate.cfg.Configuration c = null;
    private ApplicationContext ctx = null;
    public static Log log = LogFactory.getLog(DbConfigurationProvider.class);
    private static Type HIBERNATE_LONG_TYPE = Hibernate.LONG;
    private static Type HIBERNATE_STRING_TYPE = Hibernate.STRING;
    private static Type HIBERNATE_BOOLEAN_TYPE = Hibernate.BOOLEAN;
    private static final String SESSION_ID_PREF_NAME = "ConfigurationSessionId";
    private static final String SESSION_CONNECTION_URL_PREF_NAME = "ConnectionURL";
    private static final String SESSION_USERNAME_PREF_NAME = "Username";
    private static final String SESSION_PASSWORD_PREF_NAME = "Password";
    private static final String SESSION_DRIVER_PREF_NAME = "Driver";
    private static final String SESSION_DIALECT_PREF_NAME = "Dialect";
    private static final String POOL_SIZE_PREF_NAME = "PoolSize";
    private static final String COLLECTION_LIST_QRY = "from r in class org.jzkit.ServiceDirectory.CollectionDescriptionDBO";
    private static final String REPOSITORY_LIST_QRY = "from r in class org.jzkit.ServiceDirectory.SearchServiceDescriptionDBO";
    private static final String PROFILE_LIST_QRY = "from r in class org.jzkit.search.util.Profile.ProfileDBO";
    private static final String CROSSWALK_LIST_QRY = "from r in class org.jzkit.search.util.Profile.CrosswalkDBO";
    private static final String TRANS_TYPE_LIST_QRY = "from r in class org.jzkit.configuration.api.RecordTransformerTypeInformationDBO";
    private static final String RECORD_MAPPING_LIST_QRY = "from r in class org.jzkit.configuration.api.RecordMappingInformationDBO";
    private static final String LANDSCAPE_QRY = "from r in class org.jzkit.ServiceDirectory.InformationLandscapeDBO";
    private static final String APP_PROPERTY_NAMES_QRY = "select r.name from org.jzkit.configuration.api.AppSettingDBO as r";
    private static final String PROFILE_DESC_QRY = "from r in class org.jzkit.search.util.Profile.ProfileDBO where r.code = ?";
    private static final String COLLECTION_DESC_QRY = "from r in class org.jzkit.ServiceDirectory.CollectionDescriptionDBO where r.code = ?";
    private static final String SERVICE_DESC_QRY = "from r in class org.jzkit.ServiceDirectory.SearchServiceDescriptionDBO where r.code = ?";
    private static final String CROSSWALK_DESC_QRY = "from r in class org.jzkit.search.util.Profile.CrosswalkDBO where r.scope='Global' and r.sourceNamespace = ?";
    private static final String LOOKUP_LANDSCAPE_OQL = "from r in class org.jzkit.ServiceDirectory.InformationLandscapeDBO where r.code=?";
    private static final String LOOKUP_PROPERTY_QRY = "from r in class org.jzkit.configuration.api.AppSettingDBO where r.name=?";
    private static final String INFO_TYPES_QUERY = "from r in class org.jzkit.ServiceDirectory.CollectionInfoTypeDBO";
    private static final String LOOKUP_INFOTYPE_QRY = "from r in class org.jzkit.ServiceDirectory.CollectionInfoTypeDBO where r.namespace=? and r.code=?";
    private static int inst_count = 0;
    private static int session_count = 0;
    private Map backend_plugins = null;

    public void initialise() throws ConfigurationException {
        log.debug((Object)" -- initialising");
        log.debug((Object)" -- Scanning classpath for jzkit backend plugins");
        this.backend_plugins = this.ctx.getBeansOfType(JZKitPluginMetadata.class);
        if (this.backend_plugins != null) {
            for (Map.Entry e : this.backend_plugins.entrySet()) {
                log.debug((Object)("Registered: " + e.getKey() + " = " + e.getValue()));
            }
        }
        log.debug((Object)" -- Scanning classpath for jzkit query builders");
        Map qb_plugins = this.ctx.getBeansOfType(QueryBuilder.class);
        if (qb_plugins != null) {
            for (Map.Entry e : qb_plugins.entrySet()) {
                log.debug((Object)("Registered QueryBuilder: " + e.getKey() + " = " + e.getValue()));
            }
        }
        log.debug((Object)"Performing bootstrap configuration - Is there an explain database?");
        log.debug((Object)"Is there a URL of default services to sync with?");
    }

    public DbConfigurationProvider(SessionFactory sf) throws ConfigurationException {
        log.info((Object)("new DbConfigurationProvider(" + ++inst_count + ")"));
        ++session_count;
        this.sf = sf;
    }

    protected void finalize() {
        log.info((Object)("finalize DbConfigurationProvider(" + --inst_count + ")"));
    }

    public CollectionDescriptionDBO lookupCollectionDescription(String collection_id) throws ConfigurationException {
        CollectionDescriptionDBO result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(COLLECTION_DESC_QRY);
            q.setParameter(0, (Object)collection_id, (Type)Hibernate.STRING);
            result = (CollectionDescriptionDBO)q.uniqueResult();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public SearchServiceDescriptionDBO lookupSearchService(String service_id) throws ConfigurationException {
        log.debug((Object)("lookupSearchService " + service_id));
        SearchServiceDescriptionDBO result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(SERVICE_DESC_QRY);
            q.setParameter(0, (Object)service_id, (Type)Hibernate.STRING);
            result = (SearchServiceDescriptionDBO)q.uniqueResult();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator enumerateVisibleCollections() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(COLLECTION_LIST_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator enumerateRepositories() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(REPOSITORY_LIST_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ProfileDBO lookupProfile(String profile_id) throws ConfigurationException {
        ProfileDBO result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(PROFILE_DESC_QRY);
            q.setParameter(0, (Object)profile_id, (Type)Hibernate.STRING);
            result = (ProfileDBO)q.uniqueResult();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator enumerateProfiles() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(PROFILE_LIST_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public CrosswalkDBO lookupCrosswalk(String source_namespace) throws ConfigurationException {
        CrosswalkDBO result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(CROSSWALK_DESC_QRY);
            q.setParameter(0, (Object)source_namespace, (Type)Hibernate.STRING);
            result = (CrosswalkDBO)q.uniqueResult();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator enumerateCrosswalks() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(CROSSWALK_LIST_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator getRegisteredConverterTypes() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(TRANS_TYPE_LIST_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator getRegisteredRecordMappings() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(RECORD_MAPPING_LIST_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public InformationLandscapeDBO lookupLandscape(String landscape_code) throws ConfigurationException {
        InformationLandscapeDBO result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(LOOKUP_LANDSCAPE_OQL);
            q.setParameter(0, (Object)landscape_code, (Type)Hibernate.STRING);
            result = (InformationLandscapeDBO)q.uniqueResult();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator enumerateLandscapes() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(LANDSCAPE_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private AppSettingDBO lookupSetting(String name) throws ConfigurationException {
        AppSettingDBO result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(LOOKUP_PROPERTY_QRY);
            q.setParameter(0, (Object)name, (Type)Hibernate.STRING);
            result = (AppSettingDBO)q.uniqueResult();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getAppProperty(String name) throws ConfigurationException {
        AppSettingDBO setting = this.lookupSetting(name);
        if (setting != null) {
            return setting.getValue();
        }
        return null;
    }

    public void setAppProperty(String name, String value) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(LOOKUP_PROPERTY_QRY);
            q.setParameter(0, (Object)name, (Type)Hibernate.STRING);
            AppSettingDBO current_setting = (AppSettingDBO)q.uniqueResult();
            if (current_setting != null) {
                current_setting.setValue(value);
            } else {
                current_setting = new AppSettingDBO(name, value);
            }
            session.saveOrUpdate((Object)current_setting);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Iterator getAppPropertyNames() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(APP_PROPERTY_NAMES_QRY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Iterator enumerateInfoTypes() throws ConfigurationException {
        Iterator result = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(INFO_TYPES_QUERY);
            result = q.iterate();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public CollectionInfoTypeDBO lookupOrCreateCollectionInfoType(String namespace, String code) throws ConfigurationException {
        CollectionInfoTypeDBO infotype = null;
        Session session = null;
        try {
            session = this.sf.openSession();
            Query q = session.createQuery(LOOKUP_INFOTYPE_QRY);
            q.setParameter(0, (Object)namespace, (Type)Hibernate.STRING);
            q.setParameter(1, (Object)code, (Type)Hibernate.STRING);
            infotype = (CollectionInfoTypeDBO)q.uniqueResult();
            if (infotype == null) {
                infotype = new CollectionInfoTypeDBO(namespace, code);
                session.saveOrUpdate((Object)infotype);
                session.flush();
                session.connection().commit();
            }
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return infotype;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void tagCollection(String collection_id, String posting_namespace, String tag) {
        log.debug((Object)("tagCollection(" + collection_id + "," + posting_namespace + "," + tag + ")"));
    }

    public Map getBackendPlugins() {
        return this.backend_plugins;
    }

    public void addOrUpdate(SearchServiceDTO svc) throws ConfigurationException {
        if (svc != null && svc.svc_code != null) {
            Session session = null;
            try {
                Object prop_value;
                String prop_name;
                log.debug((Object)"addOrUpdate SearchServiceDTO");
                session = this.sf.openSession();
                Query q = session.createQuery(SERVICE_DESC_QRY);
                q.setParameter(0, (Object)svc.svc_code, (Type)Hibernate.STRING);
                SearchServiceDescriptionDBO ssd = (SearchServiceDescriptionDBO)q.uniqueResult();
                if (ssd == null) {
                    ssd = new SearchServiceDescriptionDBO();
                    ssd.setCode(svc.svc_code);
                }
                ssd.setServiceShortName(svc.svc_name);
                ssd.setServiceName(svc.svc_name);
                ssd.setClassName(svc.svc_class);
                if (svc.properties != null) {
                    for (Map.Entry<String, String> entry : svc.properties.entrySet()) {
                        if (entry != null) {
                            prop_name = entry.getKey().toString();
                            prop_value = entry.getValue().toString();
                            log.debug((Object)("store preference " + prop_name + "=" + (String)prop_value));
                            ssd.getPreferences().put(prop_name, (String)prop_value);
                            continue;
                        }
                        log.error((Object)"Map entry was null");
                    }
                } else {
                    log.info((Object)"No preferences in SSD DTO");
                }
                if (svc.archetypes != null) {
                    for (Map.Entry<String, String> entry : svc.properties.entrySet()) {
                        if (entry != null) {
                            prop_name = entry.getKey().toString();
                            prop_value = entry.getValue().toString();
                            log.debug((Object)("store archetype " + prop_name + "=" + (String)prop_value));
                            ssd.getRecordArchetypes().put(prop_name, (String)prop_value);
                            continue;
                        }
                        log.error((Object)"Map entry was null");
                    }
                } else {
                    log.info((Object)"No archetypes in SSD DTO");
                }
                if (svc.collections != null) {
                    for (CollectionDefDTO collectionDefDTO : svc.collections) {
                        CollectionDescriptionDBO coll = new CollectionDescriptionDBO();
                        coll.setCode(collectionDefDTO.code);
                        coll.setCollectionName(collectionDefDTO.name);
                        coll.setLocalId(collectionDefDTO.localid);
                        coll.setProfile(collectionDefDTO.profile);
                        ssd.getCollections().add(coll);
                    }
                } else {
                    log.info((Object)"No archetypes in SSD DTO");
                }
                if (svc.valid_indexes != null) {
                    for (Map.Entry entry : svc.valid_indexes.entrySet()) {
                        if (entry == null) continue;
                        prop_name = entry.getKey().toString();
                        prop_value = (Set)entry.getValue();
                        log.debug((Object)("store valid " + prop_name + " attrs"));
                        AttributeSetDBO valid_attr_set = ssd.getValidAttrs().get(prop_name);
                        if (valid_attr_set == null) {
                            valid_attr_set = new AttributeSetDBO();
                            ssd.getValidAttrs().put(prop_name, valid_attr_set);
                        }
                        Iterator i2 = prop_value.iterator();
                        while (i2.hasNext()) {
                            String valid_attr = (String)i2.next();
                            valid_attr_set.getAttrs().add(new AttrValue(valid_attr));
                        }
                    }
                } else {
                    log.info((Object)"No archetypes in SSD DTO");
                }
                if (svc.valid_indexes != null) {
                    for (Map.Entry entry : svc.valid_indexes.entrySet()) {
                        if (entry == null) continue;
                        prop_name = entry.getKey().toString();
                        prop_value = entry.getValue().toString();
                        ssd.getServiceSpecificTranslations().put(prop_name, new AttrValue((String)prop_value));
                    }
                } else {
                    log.info((Object)"No archetypes in SSD DTO");
                }
                log.debug((Object)"Save or update SSD");
                session.saveOrUpdate((Object)ssd);
                session.flush();
                session.connection().commit();
            }
            catch (SQLException sqle) {
                throw new ConfigurationException(sqle.toString());
            }
            catch (HibernateException he) {
                throw new ConfigurationException(he.toString());
            }
            finally {
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void registerCollectionDescription(CollectionDescriptionDBO cd) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.saveOrUpdate((Object)cd);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerSearchService(SearchServiceDescriptionDBO ssd) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            log.debug((Object)("Checking no ssd with code " + ssd.getCode() + " is present"));
            Query q = session.createQuery(SERVICE_DESC_QRY);
            q.setParameter(0, (Object)ssd.getCode(), (Type)Hibernate.STRING);
            SearchServiceDescriptionDBO result = (SearchServiceDescriptionDBO)q.uniqueResult();
            if (result == null) {
                log.debug((Object)"Verifying attributes");
                for (AttributeSetDBO attr_set : ssd.getValidAttrs().values()) {
                    session.saveOrUpdate((Object)attr_set);
                }
                log.debug((Object)"flushing attr sets");
                session.flush();
                log.debug((Object)"Creating SSD");
                session.saveOrUpdate((Object)ssd);
                session.flush();
                session.connection().commit();
            } else {
                log.info((Object)("Search service with code " + ssd.getCode() + " already exists"));
            }
        }
        catch (SQLException sqle) {
            throw new ConfigurationException("Problem registering search service", sqle);
        }
        catch (HibernateException he) {
            throw new ConfigurationException("Problem registering search service", he);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerProfile(ProfileDBO p) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.saveOrUpdate((Object)p);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerCrosswalk(CrosswalkDBO crosswalk) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.saveOrUpdate((Object)crosswalk);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerRecordModelConverterType(RecordTransformerTypeInformationDBO info) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.saveOrUpdate((Object)info);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerRecordModelMapping(RecordMappingInformationDBO info) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.saveOrUpdate((Object)info);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerLandscape(InformationLandscapeDBO landscape) throws ConfigurationException {
        Session session = null;
        try {
            session = this.sf.openSession();
            session.saveOrUpdate((Object)landscape);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle.toString());
        }
        catch (HibernateException he) {
            throw new ConfigurationException(he.toString());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

