/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.sources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.tools.i18n.TranslationPackBuilder;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.domain.Source_;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.resources.Resources;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/sources"})
@Tag(name="sources", description="Source catalogue operations")
@Controller(value="sources")
public class SourcesApi {
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    LanguageRepository langRepository;
    @Autowired
    private TranslationPackBuilder translationPackBuilder;

    @Operation(summary="Get all sources", description="Sources are the local catalogue, subportal, external catalogue (when importing MEF files) or harvesters.")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of source catalogues.")})
    @ResponseBody
    public List<Source> getSources(@Parameter(description="Group owner of the source (only applies to subportal).") @RequestParam(value="group", required=false) Integer group, @Parameter(hidden=true) HttpServletResponse response) throws Exception {
        ApiUtils.setHeaderVaryOnAccept(response);
        if (group != null) {
            return this.sourceRepository.findByGroupOwner(group.intValue());
        }
        return this.sourceRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Source_.name}));
    }

    @Operation(summary="Get portal list", description="List all subportal available.")
    @RequestMapping(produces={"text/html"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of portals.")})
    @ResponseBody
    public void getSubPortals(@Parameter(hidden=true) HttpServletResponse response) throws Exception {
        List sources = this.sourceRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Source_.name}));
        Element sourcesList = new Element("sources");
        sources.stream().map(GeonetEntity::asXml).forEach(arg_0 -> ((Element)sourcesList).addContent(arg_0));
        response.setContentType("text/html");
        ApiUtils.setHeaderVaryOnAccept(response);
        response.getWriter().write(new XsltResponseWriter(null, "portal").withJson("catalog/locales/en-core.json").withJson("catalog/locales/en-search.json").withXml(sourcesList).withParam("cssClass", "gn-portal").withXsl("xslt/ui-search/portal-list.xsl").asHtml());
    }

    @Operation(summary="Get all sources by type", description="Sources are the local catalogue, subportal, external catalogue (when importing MEF files) or harvesters.")
    @RequestMapping(value={"/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Source> getSourcesByType(@PathVariable SourceType type) throws Exception {
        return this.sourceRepository.findByType(type, SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Source_.name}));
    }

    @Operation(summary="Add a source", description="")
    @RequestMapping(method={RequestMethod.PUT}, produces={"text/plain"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Source created."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseBody
    public ResponseEntity addSource(@Parameter(name="source") @RequestBody Source source, @Parameter(hidden=true) HttpServletRequest request) {
        Optional existing = this.sourceRepository.findById((Object)source.getUuid());
        if (existing.isPresent()) {
            throw new IllegalArgumentException(String.format("A source with uuid '%s' already exist", source.getUuid()));
        }
        Source existingWithSameName = this.sourceRepository.findOneByName(source.getName());
        if (existingWithSameName != null) {
            throw new IllegalArgumentException(String.format("A source with name '%s' already exist", source.getName()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = source.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            source.getLabelTranslations().put(l.getId(), label == null ? source.getName() : label);
        }
        Source sourceCreated = (Source)this.sourceRepository.save((Object)source);
        this.copySourceLogo(source, request);
        this.translationPackBuilder.clearCache();
        return new ResponseEntity((Object)sourceCreated.getUuid(), HttpStatus.CREATED);
    }

    private void copySourceLogo(Source source, HttpServletRequest request) {
        if (source.getLogo() != null) {
            ServiceContext context = ApiUtils.createServiceContext(request);
            ((Resources)context.getBean(Resources.class)).copyLogo(context, "images" + File.separator + "harvesting" + File.separator + source.getLogo(), source.getUuid());
        }
    }

    @Operation(summary="Update a source", description="")
    @RequestMapping(value={"/{sourceIdentifier}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Source updated."), @ApiResponse(responseCode="404", description="Source not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity updateSource(@Parameter(description="Source identifier", required=true) @PathVariable String sourceIdentifier, @Parameter(name="source") @RequestBody Source source, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        Optional existingSource = this.sourceRepository.findById((Object)sourceIdentifier);
        if (existingSource.isPresent()) {
            boolean clearTranslationPackCache = !((Source)existingSource.get()).getLabelTranslations().equals(source.getLabelTranslations());
            this.updateSource(sourceIdentifier, source, this.sourceRepository);
            this.copySourceLogo(source, request);
            if (clearTranslationPackCache) {
                this.translationPackBuilder.clearCache();
            }
        } else {
            throw new ResourceNotFoundException(String.format("Source with uuid '%s' does not exist.", sourceIdentifier));
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Remove a source", description="")
    @RequestMapping(value={"/{sourceIdentifier}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Source deleted."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseBody
    public ResponseEntity deleteSource(@Parameter(description="Source identifier", required=true) @PathVariable String sourceIdentifier, @Parameter(hidden=true) HttpServletRequest request) throws ResourceNotFoundException {
        Optional existingSource = this.sourceRepository.findById((Object)sourceIdentifier);
        if (existingSource.isPresent()) {
            if (((Source)existingSource.get()).getLogo() != null) {
                ServiceContext context = ApiUtils.createServiceContext(request);
                Resources resources = (Resources)context.getBean(Resources.class);
                Path logoDir = resources.locateLogosDir(context);
                try {
                    resources.deleteImageIfExists(((Source)existingSource.get()).getUuid() + "." + FilenameUtils.getExtension((String)((Source)existingSource.get()).getLogo()), logoDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            throw new ResourceNotFoundException(String.format("Source with uuid '%s' does not exist.", sourceIdentifier));
        }
        this.sourceRepository.delete(existingSource.get());
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void updateSource(String sourceIdentifier, Source source, SourceRepository sourceRepository) {
        sourceRepository.update((Serializable)((Object)sourceIdentifier), entity -> {
            entity.setName(source.getName());
            entity.setUuid(source.getUuid());
            entity.setType(source.getType());
            entity.setFilter(source.getFilter());
            entity.setGroupOwner(source.getGroupOwner());
            entity.setServiceRecord(source.getServiceRecord());
            entity.setUiConfig(source.getUiConfig());
            entity.setLogo(source.getLogo());
            Map labelTranslations = source.getLabelTranslations();
            if (labelTranslations != null) {
                entity.getLabelTranslations().clear();
                entity.getLabelTranslations().putAll(labelTranslations);
            }
        });
    }
}

