/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.transform.TransformerFactory;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.dbcp2.BasicDataSource;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.TransformerFactoryFactory;

public class SiteInformation {
    final Properties properties = System.getProperties();
    private HashMap<String, String> catProperties = new HashMap();
    private HashMap<String, String> indexProperties = new HashMap();
    private HashMap<String, String> systemProperties = new HashMap();
    private HashMap<String, String> databaseProperties = new HashMap();
    private HashMap<String, String> versionProperties = new HashMap();

    public SiteInformation(ServiceContext context, GeonetContext gc) {
        if (context.getUserSession().isAuthenticated()) {
            this.loadCatalogueInfo(gc);
            try {
                this.loadDatabaseInfo(context);
            }
            catch (SQLException e) {
                Log.error((String)"geonetwork", (Object)e.getMessage(), (Throwable)e);
            }
            try {
                this.loadIndexInfo(context);
            }
            catch (IOException e) {
                Log.error((String)"geonetwork", (Object)e.getMessage(), (Throwable)e);
            }
            this.loadVersionInfo(context);
            this.loadSystemInfo();
        }
    }

    @JsonProperty(value="catalogue")
    public HashMap<String, String> getCatProperties() {
        return this.catProperties;
    }

    public void setCatProperties(HashMap<String, String> catProperties) {
        this.catProperties = catProperties;
    }

    @JsonProperty(value="index")
    public HashMap<String, String> getIndexProperties() {
        return this.indexProperties;
    }

    public void setIndexProperties(HashMap<String, String> indexProperties) {
        this.indexProperties = indexProperties;
    }

    @JsonProperty(value="main")
    public HashMap<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(HashMap<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @JsonProperty(value="database")
    public HashMap<String, String> getDatabaseProperties() {
        return this.databaseProperties;
    }

    public void setDatabaseProperties(HashMap<String, String> databaseProperties) {
        this.databaseProperties = databaseProperties;
    }

    @JsonProperty(value="version")
    public Map<String, String> getVersionProperties() {
        return this.versionProperties;
    }

    public void setVersionProperties(HashMap<String, String> versionProperties) {
        this.versionProperties = versionProperties;
    }

    private void loadCatalogueInfo(GeonetContext gc) {
        String[] props;
        ServiceConfig sc = (ServiceConfig)gc.getBean(ServiceConfig.class);
        for (String prop : props = new String[]{"dataDir", "codeListDir", "configDir", "indexConfigDir", "schemaPluginsDir", "subversionPath", "resources", "formatterPath", "backupDir"}) {
            this.catProperties.put("data." + prop, sc.getValue(prop));
        }
    }

    private void loadSystemInfo() {
        this.systemProperties.put("java.version", this.properties.getProperty("java.version"));
        this.systemProperties.put("java.vm.name", this.properties.getProperty("java.vm.name"));
        this.systemProperties.put("java.vm.vendor", this.properties.getProperty("java.vm.vendor"));
        this.systemProperties.put("os.name", this.properties.getProperty("os.name"));
        this.systemProperties.put("os.arch", this.properties.getProperty("os.arch"));
        try {
            TransformerFactory transFact = TransformerFactoryFactory.getTransformerFactory();
            this.systemProperties.put("xslt.factory", transFact.getClass().getName());
        }
        catch (Exception e) {
            this.systemProperties.put("xslt.factory", "Exception:" + e.getMessage());
        }
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totMem = Runtime.getRuntime().totalMemory() / 1024L;
        this.systemProperties.put("mem.free", "" + freeMem);
        this.systemProperties.put("mem.total", "" + totMem);
    }

    private void loadIndexInfo(ServiceContext context) throws IOException {
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatabaseInfo(ServiceContext context) throws SQLException {
        String dbURL = null;
        try (Connection connection = null;){
            connection = ((DataSource)context.getBean(DataSource.class)).getConnection();
            dbURL = connection.getMetaData().getURL();
            this.databaseProperties.put("db.openattempt", "Database Opened Successfully");
            if (connection instanceof BasicDataSource) {
                BasicDataSource basicDataSource = (BasicDataSource)connection;
                try {
                    this.databaseProperties.put("db.numactive", "" + basicDataSource.getNumActive());
                    this.databaseProperties.put("db.numidle", "" + basicDataSource.getNumIdle());
                    this.databaseProperties.put("db.maxactive", "" + basicDataSource.getMaxTotal());
                }
                catch (Exception e) {
                    this.databaseProperties.put("db.statserror", "Failed to get stats on database connections. Error is: " + e.getMessage());
                }
            }
        }
        this.databaseProperties.put("db.url", dbURL);
    }

    private void loadVersionInfo(ServiceContext context) {
        Properties prop = new Properties();
        try (InputStream input = this.getClass().getResourceAsStream("/git.properties");){
            prop.load(input);
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = prop.getProperty(key);
                this.versionProperties.put(key, value);
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork", (Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

