/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.Attributes;

public abstract class TNodeFactory {
    public static final String FMT_PREFIX = "fmt-";
    public static final List<String> ATTRIBUTE_NAME_PREFIXES = Lists.newArrayList((Object[])new String[]{"fmt-", "x-fmt-", "data-fmt-"});
    @Autowired
    protected TextContentParser textContentParser;

    public abstract boolean applicable(String var1, String var2, Attributes var3);

    public abstract TNode create(String var1, String var2, Attributes var3) throws IOException;

    protected String getValue(Attributes attributes, String name) {
        for (String attributeNamePrefix : ATTRIBUTE_NAME_PREFIXES) {
            int index = attributes.getIndex(attributeNamePrefix + name);
            if (index <= -1) continue;
            return attributes.getValue(index);
        }
        return null;
    }

    protected boolean hasAttribute(Attributes attributes, String ... attNames) {
        for (String att : attNames) {
            if (this.getValue(attributes, att) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean getBooleanAttribute(Attributes attributes, String attName, boolean defaultVal) {
        String replaceAtt = this.getValue(attributes, attName);
        boolean value = defaultVal;
        if (replaceAtt != null) {
            value = replaceAtt.isEmpty() || replaceAtt.equalsIgnoreCase("y") || replaceAtt.equalsIgnoreCase("true") || replaceAtt.equalsIgnoreCase("yes");
        }
        return value;
    }
}

