/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.editing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.editing.AjaxEditUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.ConcurrentUpdateEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.schema.MultilingualSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

class EditUtils {
    protected ServiceContext context;
    protected DataManager dataManager;
    protected XmlSerializer xmlSerializer;
    protected GeonetContext gc;
    protected AccessManager accessMan;
    protected UserSession session;
    protected IMetadataValidator metadataValidator;

    public EditUtils(ServiceContext context) {
        this.context = context;
        this.gc = (GeonetContext)context.getHandlerContext("contextName");
        this.dataManager = (DataManager)this.gc.getBean(DataManager.class);
        this.xmlSerializer = (XmlSerializer)this.gc.getBean(XmlSerializer.class);
        this.accessMan = (AccessManager)this.gc.getBean(AccessManager.class);
        this.session = context.getUserSession();
        this.metadataValidator = (IMetadataValidator)this.gc.getBean(IMetadataValidator.class);
    }

    protected static void addMissingGeoNetRef(Element element) {
        Iterator descendants = element.getDescendants();
        ArrayList list = Lists.newArrayList((Iterator)descendants);
        for (Object descendant : list) {
            Element geonetRef;
            Element e;
            if (!(descendant instanceof Element) || (e = (Element)descendant).getName() == "element" || e.getNamespace() == Edit.NAMESPACE || (geonetRef = e.getChild("element", Edit.NAMESPACE)) != null) continue;
            geonetRef = new Element("element", Edit.NAMESPACE);
            geonetRef.setAttribute("ref", "");
            e.addContent((Content)geonetRef);
        }
    }

    public void preprocessUpdate(Element params, ServiceContext context) throws Exception {
        int iLocalId;
        String sessionTabProperty;
        String id = Util.getParam((Element)params, (String)"id");
        Element elCurrTab = params.getChild("currTab");
        Element elCurrPos = params.getChild("position");
        boolean useEditTab = Util.getParam((Element)params, (String)"editTab", (boolean)false);
        String string = sessionTabProperty = useEditTab ? "metadata.editing.tab" : "metadata.show";
        if (elCurrTab != null) {
            this.session.setProperty(sessionTabProperty, (Object)elCurrTab.getText());
        }
        if (elCurrPos != null) {
            this.session.setProperty("metadata.position", (Object)elCurrPos.getText());
        }
        if (!this.dataManager.existsMetadata(iLocalId = Integer.parseInt(id))) {
            throw new BadParameterEx("id", (Object)id);
        }
        if (!this.accessMan.canEdit(context, id)) {
            Lib.resource.denyAccess(context);
        }
    }

    public void updateContent(Element params, boolean validate) throws Exception {
        this.updateContent(params, validate, false);
    }

    public void updateContent(Element params, boolean validate, boolean embedded) throws Exception {
        String id = Util.getParam((Element)params, (String)"id");
        String version = Util.getParam((Element)params, (String)"version");
        String minor = Util.getParam((Element)params, (String)"minor", (String)"false");
        HashMap<String, String> htChanges = new HashMap<String, String>(100);
        List list = params.getChildren();
        for (Element el : list) {
            String sPos = el.getName();
            String sVal = el.getText();
            if (!sPos.startsWith("_")) continue;
            htChanges.put(sPos.substring(1), sVal);
        }
        AbstractMetadata result = null;
        boolean ufo = true;
        boolean index = true;
        boolean updateDateStamp = !minor.equals("true");
        String changeDate = null;
        if (embedded) {
            Element updatedMetada = new AjaxEditUtils(this.context).applyChangesEmbedded(id, htChanges, version);
            if (updatedMetada != null) {
                result = this.dataManager.updateMetadata(this.context, id, updatedMetada, false, ufo, index, this.context.getLanguage(), changeDate, updateDateStamp);
            }
        } else {
            Element updatedMetada = this.applyChanges(id, htChanges, version);
            if (updatedMetada != null) {
                result = this.dataManager.updateMetadata(this.context, id, updatedMetada, validate, ufo, index, this.context.getLanguage(), changeDate, updateDateStamp);
            }
        }
        if (result == null) {
            throw new ConcurrentUpdateEx(id);
        }
    }

    private Element applyChanges(String id, Map<String, String> changes, String currVersion) throws Exception {
        Lib.resource.checkEditPrivilege(this.context, id);
        Element md = this.xmlSerializer.select(this.context, id);
        if (md == null) {
            return null;
        }
        EditLib editLib = this.dataManager.getEditLib();
        String schema = this.dataManager.getMetadataSchema(id);
        editLib.expandElements(schema, md);
        editLib.enumerateTree(md);
        if (currVersion != null && !editLib.getVersion(id).equals(currVersion)) {
            return null;
        }
        for (Map.Entry<String, String> entry : changes.entrySet()) {
            Element el;
            String ref = entry.getKey().trim();
            String val = entry.getValue().trim();
            String attr = null;
            if (this.updatedLocalizedTextElement(md, schema, ref, val, editLib)) continue;
            int at = ref.indexOf(95);
            if (at != -1) {
                attr = ref.substring(at + 1);
                ref = ref.substring(0, at);
            }
            boolean xmlContent = false;
            if (ref.startsWith("X")) {
                ref = ref.substring(1);
                xmlContent = true;
            }
            if ((el = editLib.findElement(md, ref)) == null) {
                throw new IllegalStateException("Element not found at ref = " + ref);
            }
            if (attr != null) {
                Integer indexColon = attr.indexOf("COLON");
                if (indexColon != -1) {
                    String namespace;
                    Namespace attrNS;
                    String prefix = attr.substring(0, indexColon);
                    String localname = attr.substring(indexColon + 5);
                    if (el.getAttribute(localname, attrNS = Namespace.getNamespace((String)prefix, (String)(namespace = editLib.getNamespace(prefix + ":" + localname, md, this.dataManager.getSchema(schema))))) == null) continue;
                    el.setAttribute(new Attribute(localname, val, attrNS));
                    continue;
                }
                if (el.getAttribute(attr) == null) continue;
                el.setAttribute(new Attribute(attr, val));
                continue;
            }
            if (xmlContent) {
                if (Log.isDebugEnabled((String)"geonetwork.editor")) {
                    Log.debug((String)"geonetwork.editor", (Object)"replacing XML content");
                }
                el.removeContent();
                val = EditLib.addGmlNamespaceToFragment((String)val);
                el.addContent((Content)Xml.loadString((String)val, (boolean)false));
                continue;
            }
            List content = el.getContent();
            Iterator iterator = content.iterator();
            while (iterator.hasNext()) {
                Content content2 = (Content)iterator.next();
                if (!(content2 instanceof Text)) continue;
                iterator.remove();
            }
            el.addContent(val);
        }
        editLib.removeEditingInfo(md);
        editLib.contractElements(md);
        return md;
    }

    protected boolean updatedLocalizedTextElement(Element md, String schema, String ref, String val, EditLib editLib) {
        if (ref.startsWith("lang")) {
            SchemaPlugin schemaPlugin;
            if (val.length() > 0 && (schemaPlugin = SchemaManager.getSchemaPlugin((String)schema)) instanceof MultilingualSchemaPlugin) {
                String language;
                String[] ids = ref.split("_");
                Element parent = editLib.findElement(md, ids[2]);
                List elems = ((MultilingualSchemaPlugin)schemaPlugin).getTranslationForElement(parent, language = ids[1]);
                if (elems != null && elems.size() > 0) {
                    ((Element)elems.get(0)).setText(val);
                } else {
                    ((MultilingualSchemaPlugin)schemaPlugin).addTranslationToElement(parent, language, val);
                    EditUtils.addMissingGeoNetRef(parent);
                }
            }
            return true;
        }
        return false;
    }

    public void updateContent(Element params) throws Exception {
        this.updateContent(params, false);
    }

    protected void swapElements(Element el1, Element el2) throws Exception {
        Element parent = el1.getParentElement();
        if (parent == null) {
            throw new IllegalArgumentException("No parent element for swapping");
        }
        int index1 = parent.indexOf((Content)el1);
        if (index1 == -1) {
            throw new IllegalArgumentException("Element 1 not found for swapping");
        }
        int index2 = parent.indexOf((Content)el2);
        if (index2 == -1) {
            throw new IllegalArgumentException("Element 2 not found for swapping");
        }
        Element el1Spare = (Element)el1.clone();
        parent.setContent(index1, (Content)((Element)el2.clone()));
        parent.setContent(index2, (Content)el1Spare);
    }
}

