/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public final class TransportActionProxy {
    private static final String PROXY_ACTION_PREFIX = "internal:transport/proxy/";

    private TransportActionProxy() {
    }

    public static void registerProxyActionWithDynamicResponseType(TransportService service, String action, boolean cancellable, Function<TransportRequest, Writeable.Reader<? extends TransportResponse>> responseFunction) {
        RequestHandlerRegistry<? extends TransportRequest> requestHandler = service.getRequestHandler(action);
        service.registerRequestHandler(TransportActionProxy.getProxyAction(action), "same", true, false, in -> cancellable ? new CancellableProxyRequest<TransportRequest>(in, requestHandler::newRequest) : new ProxyRequest<TransportRequest>(in, requestHandler::newRequest), new ProxyRequestHandler(service, action, responseFunction));
    }

    public static void registerProxyAction(TransportService service, String action, boolean cancellable, Writeable.Reader<? extends TransportResponse> reader) {
        RequestHandlerRegistry<? extends TransportRequest> requestHandler = service.getRequestHandler(action);
        service.registerRequestHandler(TransportActionProxy.getProxyAction(action), "same", true, false, in -> cancellable ? new CancellableProxyRequest<TransportRequest>(in, requestHandler::newRequest) : new ProxyRequest<TransportRequest>(in, requestHandler::newRequest), new ProxyRequestHandler(service, action, request -> reader));
    }

    public static String getProxyAction(String action) {
        return PROXY_ACTION_PREFIX + action;
    }

    public static TransportRequest wrapRequest(DiscoveryNode node, TransportRequest request) {
        return new ProxyRequest<TransportRequest>(request, node);
    }

    public static TransportRequest unwrapRequest(TransportRequest request) {
        if (request instanceof ProxyRequest) {
            return ((ProxyRequest)request).wrapped;
        }
        return request;
    }

    public static String unwrapAction(String action) {
        assert (TransportActionProxy.isProxyAction(action)) : "Attempted to unwrap non-proxy action: " + action;
        return action.substring(PROXY_ACTION_PREFIX.length());
    }

    public static boolean isProxyAction(String action) {
        return action.startsWith(PROXY_ACTION_PREFIX);
    }

    public static boolean isProxyRequest(TransportRequest request) {
        return request instanceof ProxyRequest;
    }

    private static class ProxyRequestHandler<T extends ProxyRequest<TransportRequest>>
    implements TransportRequestHandler<T> {
        private final TransportService service;
        private final String action;
        private final Function<TransportRequest, Writeable.Reader<? extends TransportResponse>> responseFunction;

        ProxyRequestHandler(TransportService service, String action, Function<TransportRequest, Writeable.Reader<? extends TransportResponse>> responseFunction) {
            this.service = service;
            this.action = action;
            this.responseFunction = responseFunction;
        }

        @Override
        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
            DiscoveryNode targetNode = ((ProxyRequest)request).targetNode;
            Object wrappedRequest = ((ProxyRequest)request).wrapped;
            assert (this.assertConsistentTaskType(task, (TransportRequest)wrappedRequest));
            TaskId taskId = task.taskInfo(this.service.localNode.getId(), false).getTaskId();
            ((TransportRequest)wrappedRequest).setParentTask(taskId);
            this.service.sendRequest(targetNode, this.action, (TransportRequest)wrappedRequest, new ProxyResponseHandler<TransportResponse>(channel, this.responseFunction.apply((TransportRequest)wrappedRequest)));
        }

        private boolean assertConsistentTaskType(Task proxyTask, TransportRequest wrapped) {
            Task targetTask = wrapped.createTask(0L, proxyTask.getType(), proxyTask.getAction(), TaskId.EMPTY_TASK_ID, Collections.emptyMap());
            assert (targetTask instanceof CancellableTask == proxyTask instanceof CancellableTask) : "Cancellable property of proxy action [" + proxyTask.getAction() + "] is configured inconsistently: expected [" + (targetTask instanceof CancellableTask) + "] actual [" + (proxyTask instanceof CancellableTask) + "]";
            return true;
        }
    }

    static class ProxyRequest<T extends TransportRequest>
    extends TransportRequest {
        final T wrapped;
        final DiscoveryNode targetNode;

        ProxyRequest(T wrapped, DiscoveryNode targetNode) {
            this.wrapped = wrapped;
            this.targetNode = targetNode;
        }

        ProxyRequest(StreamInput in, Writeable.Reader<T> reader) throws IOException {
            super(in);
            this.targetNode = new DiscoveryNode(in);
            this.wrapped = (TransportRequest)reader.read(in);
            this.setParentTask(((TransportRequest)this.wrapped).getParentTask());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.targetNode.writeTo(out);
            ((TransportRequest)this.wrapped).writeTo(out);
        }
    }

    private static class CancellableProxyRequest<T extends TransportRequest>
    extends ProxyRequest<T> {
        CancellableProxyRequest(StreamInput in, Writeable.Reader<T> reader) throws IOException {
            super(in, reader);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers){

                @Override
                public String getDescription() {
                    return "proxy task [" + wrapped.getDescription() + "]";
                }
            };
        }
    }

    private static class ProxyResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final Writeable.Reader<T> reader;
        private final TransportChannel channel;

        ProxyResponseHandler(TransportChannel channel, Writeable.Reader<T> reader) {
            this.reader = reader;
            this.channel = channel;
        }

        @Override
        public T read(StreamInput in) throws IOException {
            return (T)((TransportResponse)this.reader.read(in));
        }

        @Override
        public void handleResponse(T response) {
            try {
                ((TransportMessage)response).incRef();
                this.channel.sendResponse((TransportResponse)response);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            try {
                this.channel.sendResponse(exp);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

