/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.inject.Named;

public class Segment {
    private final String path;
    private final String etag;
    @Named(value="size_bytes")
    private final long sizeBytes;

    private Segment(String path, String etag, long sizeBytes) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        this.etag = (String)Preconditions.checkNotNull((Object)etag, (String)"etag of %s", (Object[])new Object[]{path});
        this.sizeBytes = sizeBytes;
    }

    public String getPath() {
        return this.path;
    }

    public String getETag() {
        return this.etag;
    }

    public long getSizeBytes() {
        return this.sizeBytes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Segment) {
            Segment that = (Segment)Segment.class.cast(object);
            return Objects.equal((Object)this.getPath(), (Object)that.getPath()) && Objects.equal((Object)this.getETag(), (Object)that.getETag()) && Objects.equal((Object)this.getSizeBytes(), (Object)that.getSizeBytes());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getETag(), this.getSizeBytes()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.getPath()).add("etag", (Object)this.getETag()).add("sizeBytes", this.getSizeBytes());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected String path;
        protected String etag;
        protected long sizeBytes;

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder sizeBytes(long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public Segment build() {
            return new Segment(this.path, this.etag, this.sizeBytes);
        }
    }
}

