/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;

@Singleton
public class BindMetadataToJsonPayload
implements Binder {
    protected final Json jsonBinder;

    @Inject
    public BindMetadataToJsonPayload(Json jsonBinder) {
        this.jsonBinder = (Json)Preconditions.checkNotNull((Object)jsonBinder, (Object)"jsonBinder");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"This binder is only valid for Map<String, String>");
        Preconditions.checkNotNull(request, (Object)"request");
        Map metadata = (Map)input;
        ArrayList clbMetadata = Lists.newArrayList();
        for (Map.Entry entry : metadata.entrySet()) {
            clbMetadata.add(ImmutableMap.of((Object)"key", entry.getKey(), (Object)"value", entry.getValue()));
        }
        String json = this.jsonBinder.toJson((Object)ImmutableMap.of((Object)"metadata", (Object)clbMetadata));
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }
}

