/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.migration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public class DeprecationInfoResponse {
    private static final ParseField CLUSTER_SETTINGS = new ParseField("cluster_settings", new String[0]);
    private static final ParseField NODE_SETTINGS = new ParseField("node_settings", new String[0]);
    private static final ParseField INDEX_SETTINGS = new ParseField("index_settings", new String[0]);
    private static final ParseField ML_SETTINGS = new ParseField("ml_settings", new String[0]);
    private final List<DeprecationIssue> clusterSettingsIssues;
    private final List<DeprecationIssue> nodeSettingsIssues;
    private final Map<String, List<DeprecationIssue>> indexSettingsIssues;
    private final List<DeprecationIssue> mlSettingsIssues;

    public DeprecationInfoResponse(List<DeprecationIssue> clusterSettingsIssues, List<DeprecationIssue> nodeSettingsIssues, Map<String, List<DeprecationIssue>> indexSettingsIssues, List<DeprecationIssue> mlSettingsIssues) {
        this.clusterSettingsIssues = Objects.requireNonNull(clusterSettingsIssues, "cluster settings issues cannot be null");
        this.nodeSettingsIssues = Objects.requireNonNull(nodeSettingsIssues, "node settings issues cannot be null");
        this.indexSettingsIssues = Objects.requireNonNull(indexSettingsIssues, "index settings issues cannot be null");
        this.mlSettingsIssues = Objects.requireNonNull(mlSettingsIssues, "ml settings issues cannot be null");
    }

    public List<DeprecationIssue> getClusterSettingsIssues() {
        return this.clusterSettingsIssues;
    }

    public List<DeprecationIssue> getNodeSettingsIssues() {
        return this.nodeSettingsIssues;
    }

    public Map<String, List<DeprecationIssue>> getIndexSettingsIssues() {
        return this.indexSettingsIssues;
    }

    public List<DeprecationIssue> getMlSettingsIssues() {
        return this.mlSettingsIssues;
    }

    private static List<DeprecationIssue> parseDeprecationIssues(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<DeprecationIssue> issues = new ArrayList<DeprecationIssue>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token != XContentParser.Token.START_OBJECT) continue;
            issues.add((DeprecationIssue)DeprecationIssue.PARSER.parse(parser, null));
        }
        return issues;
    }

    public static DeprecationInfoResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashMap<String, List<DeprecationIssue>> indexSettings = new HashMap<String, List<DeprecationIssue>>();
        ArrayList<DeprecationIssue> clusterSettings = new ArrayList<DeprecationIssue>();
        ArrayList<DeprecationIssue> nodeSettings = new ArrayList<DeprecationIssue>();
        ArrayList<DeprecationIssue> mlSettings = new ArrayList<DeprecationIssue>();
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (CLUSTER_SETTINGS.getPreferredName().equals(fieldName)) {
                clusterSettings.addAll(DeprecationInfoResponse.parseDeprecationIssues(parser));
                continue;
            }
            if (NODE_SETTINGS.getPreferredName().equals(fieldName)) {
                nodeSettings.addAll(DeprecationInfoResponse.parseDeprecationIssues(parser));
                continue;
            }
            if (ML_SETTINGS.getPreferredName().equals(fieldName)) {
                mlSettings.addAll(DeprecationInfoResponse.parseDeprecationIssues(parser));
                continue;
            }
            if (!INDEX_SETTINGS.getPreferredName().equals(fieldName)) continue;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                String key = parser.currentName();
                List<DeprecationIssue> value = DeprecationInfoResponse.parseDeprecationIssues(parser);
                if (value.size() <= 0) continue;
                indexSettings.put(key, value);
            }
        }
        return new DeprecationInfoResponse(clusterSettings, nodeSettings, indexSettings, mlSettings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeprecationInfoResponse that = (DeprecationInfoResponse)o;
        return Objects.equals(this.clusterSettingsIssues, that.clusterSettingsIssues) && Objects.equals(this.nodeSettingsIssues, that.nodeSettingsIssues) && Objects.equals(this.mlSettingsIssues, that.mlSettingsIssues) && Objects.equals(this.indexSettingsIssues, that.indexSettingsIssues);
    }

    public int hashCode() {
        return Objects.hash(this.clusterSettingsIssues, this.nodeSettingsIssues, this.indexSettingsIssues, this.mlSettingsIssues);
    }

    public String toString() {
        return this.clusterSettingsIssues + ":" + this.nodeSettingsIssues + ":" + this.indexSettingsIssues + ":" + this.mlSettingsIssues;
    }

    public static class DeprecationIssue {
        private static final ParseField LEVEL = new ParseField("level", new String[0]);
        private static final ParseField MESSAGE = new ParseField("message", new String[0]);
        private static final ParseField URL = new ParseField("url", new String[0]);
        private static final ParseField DETAILS = new ParseField("details", new String[0]);
        private static final ParseField RESOLVE_DURING_ROLLING_UPGRADE = new ParseField("resolve_during_rolling_upgrade", new String[0]);
        private static final ParseField META = new ParseField("_meta", new String[0]);
        static final ConstructingObjectParser<DeprecationIssue, Void> PARSER = new ConstructingObjectParser("deprecation_issue", true, args -> {
            String logLevel = (String)args[0];
            String message = (String)args[1];
            String url = (String)args[2];
            String details = (String)args[3];
            boolean resolveDuringRollingUpgrade = (Boolean)args[4];
            Map meta = (Map)args[5];
            return new DeprecationIssue(Level.fromString(logLevel), message, url, details, resolveDuringRollingUpgrade, meta);
        });
        private final Level level;
        private final String message;
        private final String url;
        private final String details;
        private final boolean resolveDuringRollingUpgrade;
        private final Map<String, Object> meta;

        public DeprecationIssue(Level level, String message, String url, @Nullable String details, boolean resolveDuringRollingUpgrade, @Nullable Map<String, Object> meta) {
            this.level = level;
            this.message = message;
            this.url = url;
            this.details = details;
            this.resolveDuringRollingUpgrade = resolveDuringRollingUpgrade;
            this.meta = meta;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDetails() {
            return this.details;
        }

        public boolean isResolveDuringRollingUpgrade() {
            return this.resolveDuringRollingUpgrade;
        }

        public Map<String, Object> getMeta() {
            return this.meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeprecationIssue that = (DeprecationIssue)o;
            return Objects.equals((Object)this.level, (Object)that.level) && Objects.equals(this.message, that.message) && Objects.equals(this.url, that.url) && Objects.equals(this.details, that.details) && Objects.equals(this.resolveDuringRollingUpgrade, that.resolveDuringRollingUpgrade) && Objects.equals(this.meta, that.meta);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.level, this.message, this.url, this.details, this.resolveDuringRollingUpgrade, this.meta});
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), LEVEL);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), MESSAGE);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), URL);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DETAILS);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), RESOLVE_DURING_ROLLING_UPGRADE);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), META);
        }

        public static enum Level {
            WARNING,
            CRITICAL;


            public static Level fromString(String value) {
                return Level.valueOf(value.toUpperCase(Locale.ROOT));
            }

            public String toString() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }
    }
}

