/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.features.AlarmApi;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;

@Beta
public class ListAlarmsToPagedIterable
extends CallerArg0ToPagedIterable<Alarm, ListAlarmsToPagedIterable> {
    private final CloudWatchApi api;

    @Inject
    ListAlarmsToPagedIterable(CloudWatchApi api) {
        this.api = (CloudWatchApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Alarm>> markerToNextForCallingArg0(final String arg0) {
        final AlarmApi alarmApi = this.api.getAlarmApiForRegion(arg0);
        return new Function<Object, IterableWithMarker<Alarm>>(){

            public IterableWithMarker<Alarm> apply(Object input) {
                return alarmApi.listAt(input.toString());
            }

            public String toString() {
                return "listAlarms(" + arg0 + ")";
            }
        };
    }
}

