/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.SortedSet;
import javax.imageio.ImageIO;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.records.extent.ExpandFactor;
import org.fao.geonet.api.regions.GeomFormat;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.RegionNotFoundEx;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class MapRenderer {
    private static final double WGS_DIAG = Math.sqrt(Math.pow(360.0, 2.0) + Math.pow(180.0, 2.0));
    private final ServiceContext context;

    public MapRenderer(ServiceContext context) {
        this.context = context;
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        return new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
    }

    public static Geometry computeGeomInDomainOfValidity(Geometry geom, CoordinateReferenceSystem mapCRS) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        Extent domainOfValidity = mapCRS.getDomainOfValidity();
        Geometry adjustedGeom = geom;
        if (domainOfValidity != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (Boolean.FALSE.equals(extent.getInclusion()) || !(extent instanceof GeographicBoundingBox) || extent == null) continue;
                GeographicBoundingBox box = (GeographicBoundingBox)extent;
                Envelope env = new Envelope(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude());
                if (env.contains(geom.getEnvelopeInternal())) {
                    return geom;
                }
                Polygon extentPolygon = JTS.toGeometry((Envelope)env);
                adjustedGeom = geom.intersection((Geometry)extentPolygon);
            }
            return adjustedGeom;
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public BufferedImage render(String id, String srs, Integer width, Integer height, String background, String geomParam, String geomType, String geomSrs, String fillColor, String strokeColor) throws Exception {
        block24: {
            appContext = this.context.getApplicationContext();
            regionGetMapBackgroundLayers = (Map)appContext.getBean("regionGetMapBackgroundLayers", Map.class);
            regionGetMapExpandFactors = (SortedSet)appContext.getBean("regionGetMapExpandFactors", SortedSet.class);
            settingManager = (SettingManager)appContext.getBean(SettingManager.class);
            geom = null;
            if (id != null) {
                daos = this.context.getApplicationContext().getBeansOfType(RegionsDAO.class).values();
                var17_17 = daos.iterator();
                while (var17_17.hasNext() && (geom = (regionsDAO = (RegionsDAO)var17_17.next()).getGeom(this.context, id, false, srs)) == null) {
                }
                if (geom == null) {
                    throw new RegionNotFoundEx(id);
                }
            } else {
                format = GeomFormat.find(geomType);
                geom = format.parse(geomParam);
                if (!geomSrs.equals(srs)) {
                    mapCRS = Region.decodeCRS((String)srs);
                    geomCRS = Region.decodeCRS((String)geomSrs);
                    geom = MapRenderer.computeGeomInDomainOfValidity(geom, mapCRS);
                    transform = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)mapCRS, (boolean)true);
                    geom = JTS.transform((Geometry)geom, (MathTransform)transform);
                }
            }
            bboxOfImage = new Envelope(geom.getEnvelopeInternal());
            expandFactor = this.calculateExpandFactor(regionGetMapExpandFactors, bboxOfImage, srs);
            bboxOfImage.expandBy(bboxOfImage.getWidth() * expandFactor, bboxOfImage.getHeight() * expandFactor);
            imageDimensions = this.calculateImageSize(bboxOfImage, width, height);
            error = null;
            if (background != null) {
                if (background.equalsIgnoreCase("settings")) {
                    bgSetting = settingManager.getValue("region/getmap/background");
                    if (bgSetting.startsWith("http://") || bgSetting.startsWith("https://")) {
                        background = settingManager.getValue("region/getmap/background");
                    } else if (regionGetMapBackgroundLayers.containsKey(bgSetting)) {
                        background = (String)regionGetMapBackgroundLayers.get(bgSetting);
                    }
                } else if (regionGetMapBackgroundLayers.containsKey(background)) {
                    background = (String)regionGetMapBackgroundLayers.get(background);
                }
                minx = Double.toString(bboxOfImage.getMinX());
                maxx = Double.toString(bboxOfImage.getMaxX());
                miny = Double.toString(bboxOfImage.getMinY());
                maxy = Double.toString(bboxOfImage.getMaxY());
                background = background.replace("{minx}", minx).replace("{maxx}", maxx).replace("{miny}", miny).replace("{maxy}", maxy).replace("{srs}", srs).replace("{width}", Integer.toString(imageDimensions.width)).replace("{height}", Integer.toString(imageDimensions.height)).replace("{MINX}", minx).replace("{MAXX}", maxx).replace("{MINY}", miny).replace("{MAXY}", maxy).replace("{SRS}", srs).replace("{WIDTH}", Integer.toString(imageDimensions.width)).replace("{HEIGHT}", Integer.toString(imageDimensions.height));
                in = null;
                try {
                    imageUrl = new URL(background);
                    conn = Lib.net.setupProxy(this.context, imageUrl);
                    in = conn.getInputStream();
                    original = ImageIO.read(in);
                    image = new BufferedImage(original.getWidth(), original.getHeight(), 2);
                    g2d = image.createGraphics();
                    g2d.drawImage((Image)original, 0, 0, null);
                    ** if (in == null) goto lbl-1000
                }
                catch (IOException e) {
                    try {
                        image = new BufferedImage(imageDimensions.width, imageDimensions.height, 2);
                        error = e;
                        ** if (in == null) goto lbl-1000
                    }
                    catch (Throwable var31_34) {
                        if (in != null) {
                            IOUtils.closeQuietly(in);
                        }
                        throw var31_34;
                    }
lbl-1000:
                    // 1 sources

                    {
                        IOUtils.closeQuietly((InputStream)in);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block24;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    IOUtils.closeQuietly((InputStream)in);
                }
lbl-1000:
                // 2 sources

                {
                    break block24;
                }
            }
            image = new BufferedImage(imageDimensions.width, imageDimensions.height, 2);
        }
        graphics = image.createGraphics();
        try {
            if (error != null) {
                graphics.drawString(error.getMessage(), 0, imageDimensions.height / 2);
            }
            shapeWriter = new ShapeWriter();
            geomFillColor = this.getColor(fillColor, new Color(0, 0, 0, 50));
            geomStrokeColor = this.getColor(strokeColor, new Color(0, 0, 0, 255));
            worldToScreenTransform = MapRenderer.worldToScreenTransform(bboxOfImage, imageDimensions);
            for (i = 0; i < geom.getNumGeometries(); ++i) {
                shape = worldToScreenTransform.createTransformedShape(shapeWriter.toShape(geom.getGeometryN(i)));
                graphics.setColor(geomFillColor);
                graphics.fill(shape);
                graphics.setColor(geomStrokeColor);
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.draw(shape);
            }
        }
        finally {
            graphics.dispose();
        }
        return image;
    }

    private Color getColor(String color, Color defaultColor) {
        if (StringUtils.isNotEmpty((String)color)) {
            String[] colorsConfig = color.split(",");
            if (colorsConfig.length == 4) {
                try {
                    return new Color(Integer.parseInt(colorsConfig[0]), Integer.parseInt(colorsConfig[1]), Integer.parseInt(colorsConfig[2]), Integer.parseInt(colorsConfig[3]));
                }
                catch (Exception e) {
                    throw new BadParameterEx(String.format("Invalid color configuration '%s'. Error is '%s'. Format must be 'RED,GREEN,BLUE,ALPHA' with integer value from 0 to 255.", color, e.getMessage()));
                }
            }
            throw new BadParameterEx(String.format("Invalid color configuration '%s'. Format must be 'RED,GREEN,BLUE,ALPHA' with integer value from 0 to 255.", color));
        }
        return defaultColor;
    }

    private double calculateExpandFactor(SortedSet<ExpandFactor> regionGetMapExpandFactors, Envelope bboxOfImage, String srs) throws Exception {
        CoordinateReferenceSystem crs = Region.decodeCRS((String)srs);
        ReferencedEnvelope env = new ReferencedEnvelope(bboxOfImage, crs);
        env = env.transform(Region.WGS84, true);
        double diag = Math.sqrt(Math.pow(env.getWidth(), 2.0) + Math.pow(env.getHeight(), 2.0));
        double scale = diag / WGS_DIAG;
        for (ExpandFactor factor : regionGetMapExpandFactors) {
            if (!(scale < factor.proportion)) continue;
            return factor.factor;
        }
        return regionGetMapExpandFactors.last().factor;
    }

    private Dimension calculateImageSize(Envelope bboxOfImage, Integer width, Integer height) {
        if (width != null) {
            return new Dimension(width, (int)Math.round(bboxOfImage.getHeight() / bboxOfImage.getWidth() * (double)width.intValue()));
        }
        return new Dimension((int)Math.round(bboxOfImage.getWidth() / bboxOfImage.getHeight() * (double)height.intValue()), height);
    }
}

