/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;
import org.fao.geonet.utils.IO;

@NotThreadSafe
public class PathHttpEntity
extends AbstractHttpEntity
implements Cloneable {
    protected final Path file;

    public PathHttpEntity(Path file, ContentType contentType) {
        this.file = (Path)Args.notNull((Object)file, (String)"File");
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public PathHttpEntity(Path file) {
        this(file, null);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getContent() throws IOException {
        return IO.newInputStream(this.file);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        try (InputStream instream = IO.newInputStream(this.file);){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
            outstream.flush();
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

