/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.Assert;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.utils.FileSystemSpecificStreamHandler;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.debug.DebuggingInputStream;
import org.fao.geonet.utils.debug.DebuggingReader;

public final class IO {
    public static final DirectoryStream.Filter<Path> DIRECTORIES_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    };
    public static final DirectoryStream.Filter<Path> FILES_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isRegularFile(entry, new LinkOption[0]);
        }
    };
    static FileSystem defaultFs = FileSystems.getDefault();
    static ThreadLocal<FileSystem> defaultFsThreadLocal = new InheritableThreadLocal<FileSystem>();

    private IO() {
    }

    public static void deleteFile(Path file, boolean throwException, String loggerModule) {
        IO.deleteFile(file, throwException, Log.createLogger(loggerModule));
    }

    public static void deleteFile(Path file, boolean throwException, Logger context) {
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            if (throwException) {
                throw new RuntimeException(e);
            }
            context.error(e);
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void copyDirectoryOrFile(@Nonnull Path from, @Nonnull Path to, boolean copyInto) throws IOException {
        IO.copyDirectoryOrFile(from, to, copyInto, null);
    }

    public static void copyDirectoryOrFile(@Nonnull Path from, @Nonnull Path to, boolean copyInto, @Nullable DirectoryStream.Filter<Path> filter) throws IOException {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Path actualTo = copyInto && Files.isDirectory(to, new LinkOption[0]) ? to.resolve(from.getFileName().toString()) : to;
        if (from.equals(to)) {
            return;
        }
        if (Files.isDirectory(from, new LinkOption[0])) {
            Assert.isTrue((!Files.isRegularFile(actualTo, new LinkOption[0]) ? 1 : 0) != 0, (String)("cannot copy a directory to a file. From: " + from + " to " + actualTo));
            if (filter == null) {
                Files.walkFileTree(from, new CopyAllFiles(from, actualTo));
            } else {
                Files.walkFileTree(from, new CopyAcceptedFiles(from, actualTo, filter));
            }
        } else if (Files.exists(from, new LinkOption[0]) && (filter == null || filter.accept(from))) {
            Path parent = actualTo.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(from, actualTo, new CopyOption[0]);
        }
    }

    public static Path relativeFile(Path relativeToDirectory, Path fileOrDirectory, Path newRelativeTo) {
        return newRelativeTo.resolve(relativeToDirectory.relativize(fileOrDirectory).toString().replace('\\', '/'));
    }

    public static void moveDirectoryOrFile(Path from, Path to, boolean copyInto) throws IOException {
        Path actualTo = copyInto && Files.isDirectory(to, new LinkOption[0]) ? to.resolve(from.getFileName()) : to;
        if (Files.exists(from, new LinkOption[0])) {
            Path parent = actualTo.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.move(from, actualTo, new CopyOption[0]);
        }
    }

    public static boolean isEmptyDir(Path dir) throws IOException {
        try (DirectoryStream<Path> children = Files.newDirectoryStream(dir);){
            Iterator<Path> iterator = children.iterator();
            boolean bl = !iterator.hasNext();
            return bl;
        }
    }

    public static void deleteFileOrDirectory(Path path) throws IOException {
        IO.deleteFileOrDirectory(path, false);
    }

    public static void deleteFileOrDirectory(Path path, final boolean ignoreErrors) throws IOException {
        block5: {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        block2: {
                            try {
                                Files.delete(file);
                            }
                            catch (Throwable t) {
                                if (ignoreErrors) break block2;
                                throw t;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        block2: {
                            try {
                                Files.delete(dir);
                            }
                            catch (Throwable t) {
                                if (ignoreErrors) break block2;
                                throw t;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                }
                catch (Throwable t) {
                    if (ignoreErrors) break block5;
                    throw t;
                }
            }
        }
    }

    public static void touch(Path file) throws IOException {
        long timestamp = System.currentTimeMillis();
        IO.touch(file, FileTime.from(timestamp, TimeUnit.MILLISECONDS));
    }

    public static void touch(Path file, FileTime timestamp) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            Path parent = file.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.setLastModifiedTime(file, timestamp);
    }

    public static Path toPath(String firstPart, String ... more) {
        FileSystem fileSystem = defaultFsThreadLocal.get();
        if (fileSystem == null) {
            fileSystem = defaultFs;
        }
        return fileSystem.getPath(firstPart, more);
    }

    public static Path toPath(URI uri) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            if (uri.toString().startsWith("jar:")) {
                throw new IllegalStateException("The zip file references in URI: " + uri + " has not been opened.  Before you can create this path you must first call ZipUtil.openZipFS with the url to the zip file");
            }
            throw new FileSystemNotFoundException("No filesystem found for the uri: " + uri);
        }
    }

    public static void setFileSystem(FileSystem newFileSystem) {
        if (newFileSystem == null) {
            newFileSystem = FileSystems.getDefault();
        }
        defaultFs = newFileSystem;
    }

    public static void setFileSystemThreadLocal(FileSystem newFileSystem) {
        defaultFsThreadLocal.set(newFileSystem);
    }

    public static URL toURL(Path textFile) throws MalformedURLException {
        return IO.toURL(textFile.toUri());
    }

    public static URL toURL(URI uri) throws MalformedURLException {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            URL url = IO.createFsSpecificURL(uri, defaultFs);
            if (url != null) {
                return url;
            }
            url = IO.createFsSpecificURL(uri, defaultFsThreadLocal.get());
            if (url != null) {
                return url;
            }
            throw e;
        }
    }

    private static URL createFsSpecificURL(URI uri, FileSystem fileSystem) throws MalformedURLException {
        if (fileSystem != null && uri.getScheme().equals(fileSystem.getPath(".", new String[0]).toUri().getScheme())) {
            return new URL(null, uri.toString(), new FileSystemSpecificStreamHandler());
        }
        return null;
    }

    public static InputStream newInputStream(Path file) throws IOException {
        if (ApplicationContextHolder.get() != null && ApplicationContextHolder.get().getBeansOfType(SystemInfo.class).size() > 0 && ((SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class)).isDevMode()) {
            return new DebuggingInputStream(file.toString(), Files.newInputStream(file, new OpenOption[0]));
        }
        return Files.newInputStream(file, new OpenOption[0]);
    }

    public static BufferedReader newBufferedReader(Path path, Charset cs) throws IOException {
        if (ApplicationContextHolder.get() != null && ApplicationContextHolder.get().getBeansOfType(SystemInfo.class).size() > 0 && ((SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class)).isDevMode()) {
            return new DebuggingReader(path.toString(), Files.newBufferedReader(path, cs));
        }
        return Files.newBufferedReader(path, cs);
    }

    private static class CopyAcceptedFiles
    extends SimpleFileVisitor<Path> {
        private final Path from;
        private final Path actualTo;
        private final DirectoryStream.Filter<Path> filter;

        public CopyAcceptedFiles(@Nonnull Path from, @Nonnull Path actualTo, @Nonnull DirectoryStream.Filter<Path> filter) {
            this.from = from;
            this.actualTo = actualTo;
            this.filter = filter;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDir = IO.relativeFile(this.from, dir, this.actualTo);
            Files.createDirectories(newDir, new FileAttribute[0]);
            Files.setLastModifiedTime(newDir, Files.getLastModifiedTime(dir, new LinkOption[0]));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.filter.accept(file)) {
                Files.copy(file, IO.relativeFile(this.from, file, this.actualTo), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Path destDir = IO.relativeFile(this.from, dir, this.actualTo);
            if (IO.isEmptyDir(destDir)) {
                Files.delete(destDir);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class CopyAllFiles
    extends SimpleFileVisitor<Path> {
        private final Path from;
        private final Path actualTo;

        public CopyAllFiles(Path from, Path actualTo) {
            this.from = from;
            this.actualTo = actualTo;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(IO.relativeFile(this.from, dir, this.actualTo), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, IO.relativeFile(this.from, file, this.actualTo), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }
    }
}

