/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import jeeves.server.context.ServiceContext;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.runtime.DocumentImpl;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.resources.CMISConfiguration;
import org.fao.geonet.resources.CMISUtils;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class CMISResources
extends Resources {
    @Autowired
    CMISConfiguration cmisConfiguration;
    @Autowired
    CMISUtils cmisUtils;
    private Path resourceBaseDir = null;

    @Override
    public Path locateResourcesDir(ServletContext context, ApplicationContext applicationContext) {
        if (this.resourceBaseDir == null) {
            Path systemFullDir = ((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class)).getSystemDataDir();
            Path resourceFullDir = ((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class)).getResourcesDir();
            this.resourceBaseDir = resourceFullDir.toString().startsWith(systemFullDir.toString()) ? systemFullDir : (resourceFullDir.isAbsolute() ? resourceFullDir.getRoot() : Paths.get(".", new String[0]));
            this.resourceBaseDir = this.resourceBaseDir.toString().equals(".") ? Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).resolve(resourceFullDir) : Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).resolve(this.resourceBaseDir.relativize(resourceFullDir));
        }
        return this.resourceBaseDir;
    }

    private String getKey(Path dir, String name) {
        return this.getKey(dir.resolve(name));
    }

    private String getKey(Path path) {
        String key;
        Path keyPath = path.startsWith(Paths.get("/", new String[0])) ? Paths.get("/", new String[0]).relativize(path) : path;
        if (this.resourceBaseDir != null) {
            if (keyPath.startsWith(Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).relativize(this.resourceBaseDir))) {
                keyPath = Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).resolve(keyPath);
            } else {
                Path resourceDir = Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).resolve(this.resourceBaseDir);
                if (keyPath.startsWith(Paths.get("/", new String[0]).relativize(resourceDir))) {
                    keyPath = Paths.get("/", new String[0]).resolve(keyPath);
                } else if (!keyPath.startsWith(resourceDir)) {
                    keyPath = resourceDir.resolve(keyPath);
                }
            }
        }
        if ((key = keyPath.getFileSystem().getSeparator().equals(this.cmisConfiguration.getFolderDelimiter()) ? keyPath.toString() : keyPath.toString().replace(keyPath.getFileSystem().getSeparator(), this.cmisConfiguration.getFolderDelimiter())).startsWith("//")) {
            key = key.substring(1);
        }
        if (key.startsWith(this.cmisConfiguration.getFolderDelimiter())) {
            return key;
        }
        return this.cmisConfiguration.getFolderDelimiter() + key;
    }

    private Path getKeyPath(String key) {
        return Paths.get(key.substring(this.cmisConfiguration.getBaseRepositoryPath().length()), new String[0]);
    }

    @Override
    @Nullable
    protected Path findImagePath(String imageName, Path logosDir) {
        String key = this.getKey(logosDir, imageName);
        if (imageName.indexOf(46) > -1) {
            if (this.cmisConfiguration.getClient().existsPath(key)) {
                return this.getKeyPath(key);
            }
            Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to locate image resource '%s'.", key));
        } else {
            try {
                CmisObject cmisObject = this.cmisConfiguration.getClient().getObjectByPath(key);
                Folder folder = (Folder)cmisObject;
                ItemIterable children = folder.getChildren();
                for (CmisObject object : children) {
                    String ext;
                    if (!(object instanceof Document) || !IMAGE_EXTENSIONS.contains((ext = FilenameUtils.getExtension((String)object.getName())).toLowerCase())) continue;
                    return this.getKeyPath(((Document)object).getName());
                }
            }
            catch (CmisObjectNotFoundException e) {
                Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to locate image resource '%s'.", key));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Resources.ResourceHolder getImage(ServiceContext context, String imageName, Path logosDir) {
        Path path = this.findImagePath(imageName, logosDir);
        if (path != null) {
            String key = this.getKey(path);
            return new CMISResourceHolder(key, false);
        }
        return null;
    }

    @Override
    public Resources.ResourceHolder getWritableImage(ServiceContext context, String imageName, Path logosDir) {
        return new CMISResourceHolder(this.getKey(logosDir, imageName), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Pair<byte[], Long> loadResource(Path resourcesDir, ServletContext context, Path appPath, String filename, byte[] defaultValue, long loadSince) throws IOException {
        Path file = this.locateResource(resourcesDir, context, appPath, filename);
        String key = this.getKey(file);
        try {
            CmisObject object = this.cmisConfiguration.getClient().getObjectByPath(key);
            if (object == null) {
                Log.info((String)"jeeves.resources", (Object)("Error loading resource " + this.cmisConfiguration.getRepositoryId() + ":" + key));
                return Pair.read((Object)defaultValue, (Object)-1L);
            }
            long lastModified = object.getLastModificationDate().toInstant().toEpochMilli();
            try (InputStream in = ((Document)object).getContentStream().getStream();){
                if (loadSince < 0L || lastModified > loadSince) {
                    byte[] content = new byte[(int)((Document)object).getContentStreamLength()];
                    new DataInputStream(in).readFully(content);
                    Pair pair = Pair.read((Object)content, (Object)lastModified);
                    return pair;
                }
                Pair pair = Pair.read((Object)defaultValue, (Object)loadSince);
                return pair;
            }
        }
        catch (CmisObjectNotFoundException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to locate resource '%s'.", key));
        }
        return Pair.read((Object)defaultValue, (Object)-1L);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Path locateResource(@Nullable Path resourcesDir, ServletContext context, Path appPath, @Nonnull String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void addFiles(DirectoryStream.Filter<Path> iconFilter, Path webappDir, HashSet<Path> result) {
        String keyFolder = this.getKey(webappDir);
        CmisObject cmisObject = this.cmisConfiguration.getClient().getObjectByPath(keyFolder);
        Folder folder = (Folder)cmisObject;
        ItemIterable children = folder.getChildren();
        for (CmisObject object : children) {
            if (!(object instanceof Document)) continue;
            Path curPath = this.getKeyPath((String)((DocumentImpl)object).getPaths().get(0));
            try {
                if (!iconFilter.accept(curPath)) continue;
                result.add(curPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Nullable
    public FileTime getLastModified(Path resourcesDir, ServletContext context, Path appPath, String filename) throws IOException {
        Path file = this.locateResource(resourcesDir, context, appPath, filename);
        String key = this.getKey(file);
        try {
            CmisObject object = this.cmisConfiguration.getClient().getObjectByPath(key);
            return FileTime.from(object.getLastModificationDate().toInstant());
        }
        catch (CmisObjectNotFoundException cmisObjectNotFoundException) {
            return null;
        }
    }

    @Override
    public void deleteImageIfExists(String image, Path dir) {
        Path icon = this.findImagePath(image, dir);
        if (icon != null) {
            this.cmisConfiguration.getClient().deleteByPath(this.getKey(icon));
        }
    }

    private class CMISResourceHolder
    implements Resources.ResourceHolder {
        private final String key;
        private Path path = null;
        private Path tempFolderPath = null;
        private boolean writeOnClose = false;
        private CmisObject cmisObject;

        private CMISResourceHolder(String key, boolean writeOnClose) {
            this.key = key;
            this.writeOnClose = writeOnClose;
            try {
                this.cmisObject = CMISResources.this.cmisConfiguration.getClient().getObjectByPath(this.key);
            }
            catch (CmisObjectNotFoundException e) {
                this.cmisObject = null;
                Log.error((String)"geonetwork.resources", (Object)String.format("Unable to locate resource '%s'.", this.key), (Throwable)e);
            }
        }

        @Override
        public Path getPath() {
            block17: {
                if (this.path != null) {
                    return this.path;
                }
                String[] splittedKey = this.key.split(CMISResources.this.cmisConfiguration.getFolderDelimiter());
                try {
                    this.tempFolderPath = Files.createTempDirectory("gn-res-" + splittedKey[splittedKey.length - 2] + "-", new FileAttribute[0]);
                    this.tempFolderPath.toFile().deleteOnExit();
                    this.path = this.tempFolderPath.resolve(splittedKey[splittedKey.length - 1]);
                    if (this.cmisObject != null) {
                        try (InputStream in = ((Document)this.cmisObject).getContentStream().getStream();){
                            Files.copy(in, this.path, StandardCopyOption.REPLACE_EXISTING);
                            break block17;
                        }
                    }
                    if (this.writeOnClose && Files.exists(this.path, new LinkOption[0])) {
                        Files.delete(this.path);
                    }
                }
                catch (IOException e) {
                    Log.error((String)"geonetwork.resources", (Object)String.format("Error getting path for resource '%s'.", this.key), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return this.path;
        }

        @Override
        public String getRelativePath() {
            return this.key;
        }

        @Override
        public FileTime getLastModifiedTime() {
            if (this.cmisObject != null) {
                return FileTime.from(this.cmisObject.getLastModificationDate().toInstant());
            }
            return null;
        }

        @Override
        public void abort() {
            this.writeOnClose = false;
        }

        @Override
        public void close() throws IOException {
            if (this.path == null) {
                return;
            }
            try {
                if (this.writeOnClose && Files.isReadable(this.path)) {
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    CMISResources.this.cmisUtils.saveDocument(this.key, this.cmisObject, properties, Files.newInputStream(this.path, new OpenOption[0]), null);
                }
            }
            finally {
                IO.deleteFileOrDirectory((Path)this.tempFolderPath, (boolean)true);
                this.path = null;
                this.tempFolderPath = null;
            }
        }
    }
}

