/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.setting;

import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;

public class SettingInfo {
    public String getSiteName() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return settingManager.getSiteName();
    }

    public String getSiteUrl() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String protocol = settingManager.getValue("system/server/protocol");
        String host = settingManager.getValue("system/server/host");
        Integer configuredPort = this.toIntOrNull("system/server/port");
        Integer port = configuredPort != null ? configuredPort : (protocol.equalsIgnoreCase("https") ? Integer.valueOf(443) : Integer.valueOf(80));
        StringBuffer sb = new StringBuffer(protocol + "://");
        sb.append(host);
        if (SettingManager.isPortRequired(protocol, port + "")) {
            sb.append(":");
            sb.append(port);
        }
        return sb.toString();
    }

    private Integer toIntOrNull(String key) {
        try {
            SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
            return Integer.parseInt(settingManager.getValue(key));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getSelectionMaxRecords() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/selectionmanager/maxrecords");
        if (value == null) {
            value = "10000";
        }
        return value;
    }

    public boolean isXLinkResolverEnabled() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/xlinkResolver/enable");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public boolean isSearchStatsEnabled() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/searchStats/enable");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public String getFeedbackEmail() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return settingManager.getValue("system/feedback/email");
    }
}

