/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.security.GeonetworkAuthenticationProvider;
import org.fao.geonet.kernel.security.keycloak.KeycloakConfiguration;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.representations.AccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class KeycloakUserUtils {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private LanguageRepository langRepository;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private GeonetworkAuthenticationProvider geonetworkAuthenticationProvider;
    @Autowired
    private KeycloakConfiguration keycloakConfiguration;
    @Autowired
    AdapterDeploymentContext adapterDeploymentContext;
    private final Cache<String, UserDetails> UserDetailsCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();

    public UserDetails getUserDetails(final AccessToken accessToken, final boolean withDbUpdate) {
        try {
            return (UserDetails)this.UserDetailsCache.get((Object)accessToken.getId(), (Callable)new Callable<UserDetails>(){

                @Override
                public UserDetails call() {
                    return KeycloakUserUtils.this.getUserDetailsNoCache(accessToken, withDbUpdate);
                }
            });
        }
        catch (ExecutionException e) {
            Log.debug((String)"geonetwork.security", (Object)"Error getting user details from token.", (Exception)e);
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    protected UserDetails getUserDetailsNoCache(AccessToken accessToken, boolean withDbUpdate) {
        BaselUser baselUser = new BaselUser(accessToken, this.keycloakConfiguration);
        if (!StringUtils.isEmpty((Object)baselUser.getUsername())) {
            User user;
            boolean newUserFlag = false;
            try {
                user = (User)this.geonetworkAuthenticationProvider.loadUserByUsername(baselUser.getUsername());
            }
            catch (UsernameNotFoundException e) {
                user = new User();
                user.setUsername(baselUser.getUsername());
                newUserFlag = true;
                Log.debug((String)"geonetwork.security", (Object)("Adding a new user: " + user));
            }
            if (!StringUtils.isEmpty((Object)baselUser.getSurname())) {
                user.setSurname(baselUser.getSurname());
            }
            if (!StringUtils.isEmpty((Object)baselUser.getFirstname())) {
                user.setName(baselUser.getFirstname());
            }
            if (!StringUtils.isEmpty((Object)baselUser.getOrganisation())) {
                user.setOrganisation(baselUser.getOrganisation());
            }
            if (!StringUtils.isEmpty((Object)baselUser.getEmail()) && !user.getEmailAddresses().contains(baselUser.getEmail())) {
                if (this.keycloakConfiguration.isUpdateProfile()) {
                    user.getEmailAddresses().clear();
                }
                user.getEmailAddresses().add(baselUser.getEmail());
            }
            if (accessToken.getAddress() != null) {
                Address address = user.getAddresses().size() > 0 ? (Address)user.getAddresses().iterator().next() : new Address();
                address.setAddress(accessToken.getAddress().getStreetAddress());
                address.setCity(accessToken.getAddress().getLocality());
                address.setState(accessToken.getAddress().getRegion());
                address.setZip(accessToken.getAddress().getPostalCode());
                address.setCountry(accessToken.getAddress().getCountry());
                user.getAddresses().clear();
                user.getAddresses().add(address);
            }
            Map<Profile, List<String>> profileGroups = this.getProfileGroups(accessToken);
            user.setProfile(this.getMaxProfile(baselUser.getProfile(), profileGroups));
            if (withDbUpdate) {
                if (newUserFlag || this.keycloakConfiguration.isUpdateProfile()) {
                    this.userRepository.save((Object)user);
                }
                if (newUserFlag || this.keycloakConfiguration.isUpdateGroup()) {
                    this.updateGroups(profileGroups, user);
                }
            }
            return user;
        }
        return null;
    }

    private Map<Profile, List<String>> getProfileGroups(AccessToken accessToken) {
        String roleGroupSeparator = this.keycloakConfiguration.getRoleGroupSeparator();
        HashMap<Profile, List<String>> profileGroups = new HashMap<Profile, List<String>>();
        HashSet<String> roleGroupList = new HashSet<String>();
        if (accessToken.getResourceAccess(this.adapterDeploymentContext.resolveDeployment(null).getResourceName()) != null) {
            for (String role : accessToken.getResourceAccess(this.adapterDeploymentContext.resolveDeployment(null).getResourceName()).getRoles()) {
                if (role.contains(roleGroupSeparator)) {
                    Log.debug((String)"geonetwork.security", (Object)("Identified group:profile (" + role + ") from user token."));
                    roleGroupList.add(role);
                    continue;
                }
                Profile p = Profile.findProfileIgnoreCase((String)role);
                if (p == null || profileGroups.containsKey(p)) continue;
                profileGroups.put(p, new ArrayList());
            }
        }
        for (String rg : roleGroupList) {
            String[] rg_role_groups = rg.split(roleGroupSeparator);
            if (rg_role_groups.length == 0 || StringUtils.isEmpty((Object)rg_role_groups[0])) continue;
            Profile p = null;
            if (rg_role_groups.length >= 1) {
                p = Profile.findProfileIgnoreCase((String)rg_role_groups[1]);
            }
            if (p == null) continue;
            List groups = profileGroups.containsKey(p) ? (List)profileGroups.get(p) : new ArrayList();
            if (rg_role_groups.length > 1) {
                groups.add(rg_role_groups[0]);
            }
            profileGroups.put(p, groups);
        }
        return profileGroups;
    }

    private void updateGroups(Map<Profile, List<String>> profileGroups, User user) {
        this.userGroupRepository.deleteAll(UserGroupSpecs.hasUserId((int)user.getId()));
        for (Profile p : profileGroups.keySet()) {
            List<String> groups = profileGroups.get(p);
            for (String rgGroup : groups) {
                Group group = this.groupRepository.findByName(rgGroup);
                if (group == null) {
                    group = new Group();
                    group.setName(rgGroup);
                    for (Language l : this.langRepository.findAll()) {
                        group.getLabelTranslations().put(l.getId(), group.getName());
                    }
                    this.groupRepository.save((Object)group);
                }
                UserGroup usergroup = new UserGroup();
                usergroup.setGroup(group);
                usergroup.setUser(user);
                Profile profile = p;
                if (profile.equals((Object)Profile.Administrator)) {
                    profile = Profile.UserAdmin;
                }
                usergroup.setProfile(profile);
                if (profile.equals((Object)Profile.Reviewer)) {
                    UserGroup ug = new UserGroup();
                    ug.setGroup(group);
                    ug.setUser(user);
                    ug.setProfile(Profile.Editor);
                    this.userGroupRepository.save((Object)ug);
                }
                this.userGroupRepository.save((Object)usergroup);
            }
        }
    }

    private Profile getMaxProfile(String defaultProfile, Map<Profile, List<String>> profileGroups) {
        Profile maxProfile = null;
        if (defaultProfile != null) {
            maxProfile = Profile.findProfileIgnoreCase((String)defaultProfile);
        }
        for (Profile p : profileGroups.keySet()) {
            if (maxProfile == null) {
                maxProfile = p;
                continue;
            }
            if (maxProfile.compareTo((Enum)p) < 0) continue;
            maxProfile = p;
        }
        if (maxProfile == null) {
            maxProfile = Profile.Guest;
        }
        return maxProfile;
    }

    private class BaselUser {
        private String username;
        private String firstname;
        private String surname;
        private String organisation;
        private String profile;
        private String email;

        BaselUser(AccessToken accessToken, KeycloakConfiguration keycloakConfiguration) {
            this.username = accessToken.getPreferredUsername();
            if (this.username == null) {
                this.username = accessToken.getName();
            }
            if (this.username != null && this.username.length() > 256) {
                this.username = this.username.substring(0, 256);
            }
            if (this.username != null && this.username.length() > 0) {
                Map profileGroups;
                this.surname = accessToken.getFamilyName();
                this.firstname = accessToken.getGivenName();
                this.email = accessToken.getEmail();
                this.organisation = null;
                if (accessToken.getOtherClaims() != null && accessToken.getOtherClaims().containsKey(keycloakConfiguration.getOrganisationKey())) {
                    this.organisation = (String)accessToken.getOtherClaims().get(keycloakConfiguration.getOrganisationKey());
                }
                if ((profileGroups = KeycloakUserUtils.this.getProfileGroups(accessToken)) != null && profileGroups.size() > 0) {
                    this.profile = KeycloakUserUtils.this.getMaxProfile(null, profileGroups).name();
                }
            }
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getFirstname() {
            return this.firstname;
        }

        public void setFirstname(String firstname) {
            this.firstname = firstname;
        }

        public String getSurname() {
            return this.surname;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public String getOrganisation() {
            return this.organisation;
        }

        public void setOrganisation(String organisation) {
            this.organisation = organisation;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

