/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.impl;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.DeduplicationModel;
import org.jzkit.search.LandscapeSpecification;
import org.jzkit.search.SearchSession;
import org.jzkit.search.SortModel;
import org.jzkit.search.StatelessSearchResultsPageDTO;
import org.jzkit.search.impl.CachedSearchSession;
import org.jzkit.search.impl.LRUCache;
import org.jzkit.search.landscape.InfoTypeSpecification;
import org.jzkit.search.landscape.MixedSpecification;
import org.jzkit.search.landscape.SimpleLandscapeSpecification;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.util.QueryModel.CQLString.CQLString;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.PrefixString.PrefixString;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StatelessQueryService
implements ApplicationContextAware {
    private static Log log = LogFactory.getLog(StatelessQueryService.class);
    private ApplicationContext ctx;
    private LRUCache sessions_by_id = null;
    private Map sessions_by_query = Collections.synchronizedMap(new HashMap());
    private int cache_size = 100;
    private long session_timeout = 180000L;

    private StatelessQueryService() {
        log.debug((Object)"new StatelessQueryService() - default cache size is 100");
        this.sessions_by_id = new LRUCache(100, this.session_timeout);
    }

    public StatelessQueryService(int cache_size) {
        this(cache_size, 0L);
    }

    public StatelessQueryService(int cache_size, long session_timeout) {
        log.debug((Object)("new StatelessQueryService(" + cache_size + "," + session_timeout + ")"));
        this.cache_size = cache_size;
        this.session_timeout = session_timeout;
        this.sessions_by_id = new LRUCache(cache_size, session_timeout);
    }

    protected void finalize() {
        log.debug((Object)"finalize()");
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public StatelessSearchResultsPageDTO getResultsPageFor(String result_set_id, QueryModel model, LandscapeSpecification landscape, int first_hit, int num_hits, RecordFormatSpecification rfs, ExplicitRecordFormatSpecification display_spec, Map additional_properties) throws SearchException, IRResultSetException, InvalidQueryException {
        StatelessSearchResultsPageDTO result = null;
        CachedSearchSession cached_search_session = null;
        String query_string = null;
        try {
            query_string = model.toInternalQueryModel(this.ctx).toString();
        }
        catch (Exception e) {
            throw new InvalidQueryException("Unable to convert query to internal query model:" + model, (Throwable)e);
        }
        String qryid = landscape + ":" + query_string;
        log.debug((Object)("getResultsPageFor (Landscape object) - " + landscape + " " + model + " rs:" + rfs + " ds:" + display_spec));
        if (result_set_id != null) {
            log.debug((Object)("got result set id " + result_set_id));
            cached_search_session = (CachedSearchSession)this.sessions_by_id.get(result_set_id);
            if (cached_search_session != null) {
                log.debug((Object)"Cache Hit on Session ID");
            }
        } else {
            log.debug((Object)("Checking cache for the supplied query string \"" + qryid + "\""));
            WeakReference wr = (WeakReference)this.sessions_by_query.get(qryid);
            if (wr != null) {
                cached_search_session = (CachedSearchSession)wr.get();
                if (cached_search_session != null && cached_search_session.isActive()) {
                    if (this.sessions_by_id.get(cached_search_session.getResultSetId()) != null) {
                        log.debug((Object)("Cache Hit on Query/Landscape ID - cache size = " + this.sessions_by_query.size()));
                    } else {
                        log.warn((Object)"Cache hit on Weak Reference for query, but get returns null. Cached object expired");
                        this.sessions_by_query.remove(qryid);
                        cached_search_session = null;
                    }
                } else {
                    log.debug((Object)"Cache Hit, but query expunged from LRU list or not active, removing from sessions_by_query");
                    this.sessions_by_query.remove(qryid);
                    cached_search_session = null;
                }
            }
        }
        if (cached_search_session == null) {
            log.info((Object)"Not located in cache... create new session");
            cached_search_session = this.newSession(landscape, model, rfs);
            if (this.cache_size > 0) {
                log.info((Object)("Session cache enabled - count=" + this.sessions_by_id.size()));
                this.sessions_by_id.put(cached_search_session.getResultSetId(), cached_search_session);
                this.sessions_by_query.put(qryid, new WeakReference<CachedSearchSession>(cached_search_session));
            }
        }
        log.debug((Object)"Asking for page of results");
        if (cached_search_session == null) {
            log.warn((Object)"Cached search session was null!");
            throw new SearchException("Cached search session was null!");
        }
        result = cached_search_session.getResultsPageFor(first_hit, num_hits, rfs, display_spec, additional_properties);
        if (this.cache_size == 0) {
            cached_search_session.setActive(false);
            cached_search_session.close();
        } else if (result.search_status == 8) {
            log.debug((Object)"Removing failed search from session by query cache");
            this.sessions_by_query.remove(qryid);
        }
        log.debug((Object)"getResultsPageFor - returning");
        return result;
    }

    public StatelessSearchResultsPageDTO getResultsPageFor(String result_set_id, String model_type, String query_string, String landscape_str, int first_hit, int num_hits, RecordFormatSpecification rfs, ExplicitRecordFormatSpecification display_spec, Map additional_properties) throws SearchException, IRResultSetException, InvalidQueryException {
        log.debug((Object)("getResultsPageFor (Landscape Str):" + landscape_str + " mt:" + model_type + " qs:" + query_string + " ds:" + display_spec + " rfs:" + rfs));
        StatelessSearchResultsPageDTO result = null;
        CachedSearchSession cached_search_session = null;
        CQLString model = null;
        String qryid = landscape_str + ":" + query_string;
        if (result_set_id != null) {
            log.debug((Object)("got result set id " + result_set_id));
            cached_search_session = (CachedSearchSession)this.sessions_by_id.get(result_set_id);
            if (cached_search_session != null) {
                log.debug((Object)"Cache Hit on Result Set ID");
            }
        } else {
            log.debug((Object)("Checking cache for the supplied query string \"" + qryid + "\""));
            WeakReference wr = (WeakReference)this.sessions_by_query.get(qryid);
            if (wr != null) {
                log.debug((Object)"Weak Reference Cache Hit.. confirming cache status");
                cached_search_session = (CachedSearchSession)wr.get();
                if (cached_search_session != null) {
                    if (this.sessions_by_id.get(cached_search_session.getResultSetId()) != null) {
                        log.debug((Object)("Cache Hit on Query/Landscape ID - cache size = " + this.sessions_by_query.size()));
                    } else {
                        log.warn((Object)"Cache hit by query ID, but session not available in lru map");
                        this.sessions_by_query.remove(qryid);
                        cached_search_session = null;
                    }
                } else {
                    log.debug((Object)("Cache Hit for weak reference, but cached session itself has been expunged, removing from sessions by query (cache size=" + this.cache_size + ")"));
                    this.sessions_by_query.remove(qryid);
                }
            } else {
                log.debug((Object)"No Weak Reference Cache Hit");
            }
        }
        if (cached_search_session == null) {
            if (landscape_str != null && query_string != null && query_string.length() > 0) {
                log.debug((Object)"Not located in cache... create new session");
                if (model_type.equalsIgnoreCase("cql")) {
                    model = new CQLString(query_string);
                } else if (model_type.equalsIgnoreCase("pqf")) {
                    model = new PrefixString(query_string);
                } else {
                    log.warn((Object)"Unsupported query");
                    throw new InvalidQueryException("Unsupported Query Type. Currently Supported types are pqf and cql");
                }
                log.debug((Object)("Storring new session using ID " + qryid));
                cached_search_session = this.newSession(this.landscapeStringToDef(landscape_str), (QueryModel)model, rfs);
                this.sessions_by_id.put(cached_search_session.getResultSetId(), cached_search_session);
                this.sessions_by_query.put(qryid, new WeakReference<CachedSearchSession>(cached_search_session));
            } else {
                throw new SearchException("No Query or Cache ID Not Found, landscape=" + landscape_str + ",query_string=" + query_string);
            }
        }
        if (cached_search_session == null) {
            log.warn((Object)"Cached search session was null!");
            throw new SearchException("Cached search session was null!");
        }
        log.debug((Object)"Asking for page of results");
        result = cached_search_session.getResultsPageFor(first_hit, num_hits, rfs, display_spec, additional_properties);
        if (result != null) {
            result.result_set_idle_time = this.session_timeout;
        }
        log.debug((Object)("Leaving getResultsPageFor, result=" + result));
        return result;
    }

    private CachedSearchSession newSession(LandscapeSpecification landscape, QueryModel model, RecordFormatSpecification rfs) throws SearchException {
        return this.newSession(landscape, model, null, null, rfs);
    }

    private CachedSearchSession newSession(LandscapeSpecification landscape, QueryModel model, DeduplicationModel deduplication_model, SortModel sort_model, RecordFormatSpecification rfs) throws SearchException {
        log.debug((Object)"newSession");
        CachedSearchSession cached_search_session = new CachedSearchSession((SearchSession)this.ctx.getBean("SearchSession"), this.ctx);
        cached_search_session.search(landscape, model, deduplication_model, sort_model, rfs);
        return cached_search_session;
    }

    private LandscapeSpecification landscapeStringToDef(String landscape) {
        MixedSpecification result = new MixedSpecification();
        String[] components = landscape.split(",");
        for (int i = 0; i < components.length; ++i) {
            String[] def_parts = components[i].split(":");
            if (def_parts.length == 1) {
                result.addSpecification(new InfoTypeSpecification("InfoType", def_parts[0]));
                continue;
            }
            if (def_parts[0].equalsIgnoreCase("infotype")) {
                result.addSpecification(new InfoTypeSpecification("InfoType", def_parts[1]));
                continue;
            }
            if (def_parts[0].equalsIgnoreCase("collection")) {
                result.addSpecification(new SimpleLandscapeSpecification(def_parts[1]));
                continue;
            }
            log.warn((Object)("Unhandled landscape specification component: " + def_parts[0] + ":" + def_parts[1]));
        }
        return result;
    }

    public void init() {
        log.debug((Object)"init()");
    }
}

