/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.DoubleCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.LongKeyDoubleMap;
import bak.pcj.map.LongKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongKeyDoubleMap
implements LongKeyDoubleMap {
    protected AbstractLongKeyDoubleMap() {
    }

    public void clear() {
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public double remove(long key) {
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            double value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultDouble();
    }

    public void putAll(LongKeyDoubleMap map) {
        LongKeyDoubleMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(long key) {
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public double get(long key) {
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultDouble();
    }

    public boolean containsValue(double value) {
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongKeyDoubleMap)) {
            return false;
        }
        LongKeyDoubleMap map = (LongKeyDoubleMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            long k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultLongHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultDoubleHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public double tget(long key) {
        double value = this.get(key);
        if (value == MapDefaults.defaultDouble() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract DoubleCollection values();

    public abstract double put(long var1, double var3);

    public abstract double lget();

    public abstract LongSet keySet();

    public abstract LongKeyDoubleMapIterator entries();
}

