/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.windbarbs;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

class WindBarb {
    private static final Logger LOGGER = Logging.getLogger(WindBarb.class);
    int knots;
    int pennants;
    int longBarbs;
    int shortBarbs;
    static int DEFAULT_BARB_LENGTH = 20;
    static int DEFAULT_BASE_PENNANT_LENGTH = 5;
    static int DEFAULT_ELEMENTS_SPACING = 5;
    static int DEFAULT_FLAGPOLE_LENGTH = 40;
    static int DEFAULT_ZERO_WIND_RADIUS = 5;
    WindBarbDefinition windBarbDefinition;
    static WindBarbDefinition DEFAULT_WINDBARB_DEFINITION = new WindBarbDefinition(DEFAULT_FLAGPOLE_LENGTH, DEFAULT_BASE_PENNANT_LENGTH, DEFAULT_ELEMENTS_SPACING, DEFAULT_BARB_LENGTH, DEFAULT_ZERO_WIND_RADIUS);

    public WindBarb(int knots) {
        this(DEFAULT_WINDBARB_DEFINITION, knots);
    }

    public WindBarb(WindBarbDefinition definition, int knots) {
        Utilities.ensureNonNull((String)"definition", (Object)definition);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating WindBarb for knots: " + knots + " and WindBarbDefinition:" + definition.toString());
        }
        this.windBarbDefinition = definition;
        this.knots = knots;
        if (knots == -1) {
            return;
        }
        if (knots < 0) {
            throw new IllegalArgumentException("Illegal wind speeds(kn): " + knots);
        }
        if (knots > 300 && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("speed is exceeding MaxSpeed = 300.\nThe related WindBarb isn't in the cache");
        }
        this.pennants = knots / 50;
        this.longBarbs = (knots - this.pennants * 50) / 10;
        this.shortBarbs = (knots - this.pennants * 50 - this.longBarbs * 10) / 5;
    }

    Shape build() {
        if (this.knots < 0) {
            return this.buildAbsentModule();
        }
        return this.buildStandardBarb();
    }

    private Shape buildStandardBarb() {
        int positionOnPath = -this.windBarbDefinition.vectorLength;
        Path2D.Double path = new Path2D.Double();
        if (this.knots < 5) {
            return new Ellipse2D.Float((float)(-this.windBarbDefinition.zeroWindRadius) / 2.0f, (float)(-this.windBarbDefinition.zeroWindRadius) / 2.0f, this.windBarbDefinition.zeroWindRadius, this.windBarbDefinition.zeroWindRadius);
        }
        ((Path2D)path).moveTo(0.0, 0.0);
        ((Path2D)path).lineTo(0.0, positionOnPath);
        if (this.pennants > 0) {
            positionOnPath = this.drawPennants(path, positionOnPath);
            positionOnPath += this.windBarbDefinition.elementsSpacing;
        }
        if (this.longBarbs > 0) {
            positionOnPath = this.drawLongBarbs(path, positionOnPath);
            positionOnPath += this.windBarbDefinition.elementsSpacing;
        }
        if (this.shortBarbs > 0) {
            positionOnPath = this.drawShortBarb(path, positionOnPath);
        }
        Shape createTransformedShape = path.createTransformedShape(AffineTransform.getScaleInstance(1.0, -1.0));
        return createTransformedShape;
    }

    Shape buildAbsentModule() {
        Path2D.Double path = new Path2D.Double();
        int positionOnPath = 0;
        ((Path2D)path).moveTo(0.0, positionOnPath);
        ((Path2D)path).lineTo(0.0, positionOnPath -= this.windBarbDefinition.vectorLength);
        ((Path2D)path).moveTo((float)this.windBarbDefinition.shortBarbLength / 2.0f, (float)positionOnPath - (float)this.windBarbDefinition.shortBarbLength / 2.0f);
        ((Path2D)path).lineTo((float)(-this.windBarbDefinition.shortBarbLength) / 2.0f, (float)positionOnPath + (float)this.windBarbDefinition.shortBarbLength / 2.0f);
        ((Path2D)path).moveTo((float)(-this.windBarbDefinition.shortBarbLength) / 2.0f, (float)positionOnPath - (float)this.windBarbDefinition.shortBarbLength / 2.0f);
        ((Path2D)path).lineTo((float)this.windBarbDefinition.shortBarbLength / 2.0f, (float)positionOnPath + (float)this.windBarbDefinition.shortBarbLength / 2.0f);
        Shape createTransformedShape = path.createTransformedShape(AffineTransform.getScaleInstance(1.0, -1.0));
        return createTransformedShape;
    }

    private int drawShortBarb(Path2D path, int positionOnPath) {
        if (this.pennants == 0 && this.longBarbs == 0) {
            positionOnPath = -this.windBarbDefinition.vectorLength + DEFAULT_ELEMENTS_SPACING;
        }
        path.moveTo(0.0, positionOnPath);
        path.lineTo(this.windBarbDefinition.shortBarbLength, (double)positionOnPath - (double)this.windBarbDefinition.basePennantLength / 4.0);
        return positionOnPath;
    }

    private int drawLongBarbs(Path2D path, int positionOnPath) {
        if (this.longBarbs <= 0) {
            return positionOnPath;
        }
        for (int elements = 0; elements < this.longBarbs; ++elements) {
            if (elements >= 1) {
                positionOnPath += this.windBarbDefinition.elementsSpacing;
            }
            path.moveTo(0.0, positionOnPath);
            path.lineTo(this.windBarbDefinition.longBarbLength, (double)positionOnPath - (double)this.windBarbDefinition.basePennantLength / 2.0);
        }
        return positionOnPath;
    }

    private int drawPennants(Path2D path, int positionOnPath) {
        if (this.pennants <= 0) {
            return positionOnPath;
        }
        for (int elements = 0; elements < this.pennants; ++elements) {
            path.moveTo(0.0, positionOnPath);
            positionOnPath = (int)((double)positionOnPath + (double)this.windBarbDefinition.basePennantLength / 2.0);
            path.lineTo(this.windBarbDefinition.longBarbLength, positionOnPath);
            positionOnPath = (int)((double)positionOnPath + (double)this.windBarbDefinition.basePennantLength / 2.0);
            path.lineTo(0.0, positionOnPath);
            path.closePath();
        }
        return positionOnPath;
    }

    static class WindBarbDefinition {
        int vectorLength;
        int basePennantLength;
        int elementsSpacing;
        int longBarbLength;
        int shortBarbLength;
        int zeroWindRadius;

        public WindBarbDefinition(int vectorLength, int basePennantLength, int elementsSpacing, int longBarbLength, int zeroWindRadius) {
            if (vectorLength <= 0) {
                throw new IllegalArgumentException("Invalid vectorLength:" + vectorLength);
            }
            if (basePennantLength <= 0) {
                throw new IllegalArgumentException("Invalid basePennantLength:" + vectorLength);
            }
            if (elementsSpacing <= 0) {
                throw new IllegalArgumentException("Invalid elementsSpacing:" + vectorLength);
            }
            if (vectorLength < elementsSpacing + basePennantLength) {
                throw new IllegalArgumentException("Invalid vectorLength<elementsSpacing+basePennantLength : " + vectorLength);
            }
            if (longBarbLength <= 0) {
                throw new IllegalArgumentException("Invalid longBarbLength:" + vectorLength);
            }
            if (zeroWindRadius <= 0) {
                throw new IllegalArgumentException("Invalid zeroWindRadius:" + vectorLength);
            }
            this.vectorLength = vectorLength;
            this.basePennantLength = basePennantLength;
            this.elementsSpacing = elementsSpacing;
            this.longBarbLength = longBarbLength;
            this.shortBarbLength = longBarbLength / 2;
            this.zeroWindRadius = zeroWindRadius;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("WindBarbDefinition [vectorLength=");
            builder.append(this.vectorLength);
            builder.append(", basePennantLength=");
            builder.append(this.basePennantLength);
            builder.append(", elementsSpacing=");
            builder.append(this.elementsSpacing);
            builder.append(", longBarbLength=");
            builder.append(this.longBarbLength);
            builder.append(", shortBarbLength=");
            builder.append(this.shortBarbLength);
            builder.append(", zeroWindRadius=");
            builder.append(this.zeroWindRadius);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.basePennantLength;
            result = 31 * result + this.elementsSpacing;
            result = 31 * result + this.longBarbLength;
            result = 31 * result + this.shortBarbLength;
            result = 31 * result + this.vectorLength;
            result = 31 * result + this.zeroWindRadius;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WindBarbDefinition)) {
                return false;
            }
            WindBarbDefinition other = (WindBarbDefinition)obj;
            if (this.basePennantLength != other.basePennantLength) {
                return false;
            }
            if (this.elementsSpacing != other.elementsSpacing) {
                return false;
            }
            if (this.longBarbLength != other.longBarbLength) {
                return false;
            }
            if (this.shortBarbLength != other.shortBarbLength) {
                return false;
            }
            if (this.vectorLength != other.vectorLength) {
                return false;
            }
            return this.zeroWindRadius == other.zeroWindRadius;
        }
    }
}

