/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LineInfo;

class LabelSplitter {
    private static final String SINGLE_CHAR_STRING = " ";
    private static final Pattern WORD_SPLITTER = Pattern.compile("(?<=\\s)(?=\\S)");
    private static final Pattern NEWLINE_SPLITTER = Pattern.compile("\\n");

    LabelSplitter() {
    }

    public List<LineInfo> layout(LabelCacheItem labelItem, Graphics2D graphics) {
        boolean singleFont;
        String text = labelItem.getLabel();
        Font[] fonts = labelItem.getTextStyle().getFonts();
        int textLength = text.length();
        boolean bl = singleFont = fonts.length == 1 || textLength == fonts[0].canDisplayUpTo(text.toCharArray(), 0, textLength);
        if (!text.contains("\n") && labelItem.getAutoWrap() <= 0 && singleFont) {
            FontRenderContext frc = graphics.getFontRenderContext();
            TextLayout layout = new TextLayout(text, fonts[0], frc);
            LineInfo lineInfo = new LineInfo();
            List<LineInfo.LineComponent> components = this.buildLineComponents(text, fonts[0], labelItem, graphics, layout);
            components.forEach(c -> lineInfo.add((LineInfo.LineComponent)c));
            return Collections.singletonList(lineInfo);
        }
        String[] splitted = NEWLINE_SPLITTER.split(text);
        ArrayList<LineInfo> lines = new ArrayList<LineInfo>();
        if (labelItem.getAutoWrap() <= 0) {
            for (String line : splitted) {
                line = this.checkForEmptyLine(line);
                LineInfo lineInfo = new LineInfo();
                List<FontRange> ranges = this.buildFontRanges(line, fonts);
                for (FontRange range : ranges) {
                    graphics.setFont(range.font);
                    FontRenderContext frc = graphics.getFontRenderContext();
                    TextLayout layout = new TextLayout(range.text, range.font, frc);
                    List<LineInfo.LineComponent> components = this.buildLineComponents(range.text, range.font, labelItem, graphics, layout);
                    components.forEach(c -> lineInfo.add((LineInfo.LineComponent)c));
                }
                lines.add(lineInfo);
            }
        } else {
            HashMap<TextAttribute, Font> map = new HashMap<TextAttribute, Font>();
            map.put(TextAttribute.FONT, fonts[0]);
            for (int i = 0; i < splitted.length; ++i) {
                String lineText = this.checkForEmptyLine(splitted[i]);
                List<FontRange> ranges = this.buildFontRanges(lineText, fonts);
                AttributedString attributed = this.buildAttributedLine(lineText, ranges);
                AttributedCharacterIterator iter = attributed.getIterator();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(iter, BreakIterator.getLineInstance(), graphics.getFontRenderContext());
                BreakIterator breaks = BreakIterator.getLineInstance();
                breaks.setText(lineText);
                int prevPosition = 0;
                while (lineMeasurer.getPosition() < iter.getEndIndex()) {
                    TextLayout layout = lineMeasurer.nextLayout(labelItem.getAutoWrap(), lineText.length(), true);
                    int newPosition = prevPosition;
                    if (layout != null) {
                        newPosition = lineMeasurer.getPosition();
                    } else {
                        int nextBoundary = breaks.following(prevPosition);
                        newPosition = nextBoundary == -1 ? lineText.length() : nextBoundary;
                        AttributedCharacterIterator subIter = attributed.getIterator(null, prevPosition, newPosition);
                        layout = new TextLayout(subIter, graphics.getFontRenderContext());
                        lineMeasurer.setPosition(newPosition);
                    }
                    List<FontRange> lineRanges = this.getLineRanges(ranges, prevPosition, newPosition);
                    LineInfo lineInfo = new LineInfo();
                    int lastLineRange = lineRanges.size() - 1;
                    int currentLineRange = 0;
                    for (FontRange range : lineRanges) {
                        int end;
                        int start = Math.max(prevPosition, range.startChar);
                        String extracted = lineText.substring(start, end = Math.min(newPosition, range.endChar));
                        if (extracted.isEmpty()) continue;
                        if (currentLineRange == 0 && currentLineRange == lastLineRange) {
                            extracted = extracted.trim();
                        } else if (currentLineRange == 0) {
                            extracted = extracted.replaceAll("^\\s+", "");
                        } else if (currentLineRange == lastLineRange) {
                            extracted = extracted.replaceAll("\\s+$", "");
                        }
                        ++currentLineRange;
                        AttributedCharacterIterator subIter = attributed.getIterator(null, start, end);
                        graphics.setFont(range.font);
                        layout = new TextLayout(subIter, graphics.getFontRenderContext());
                        List<LineInfo.LineComponent> components = this.buildLineComponents(extracted, range.font, labelItem, graphics, layout);
                        components.forEach(c -> lineInfo.add((LineInfo.LineComponent)c));
                    }
                    lines.add(lineInfo);
                    prevPosition = newPosition;
                }
            }
        }
        return lines;
    }

    private List<LineInfo.LineComponent> buildLineComponents(String text, Font font, LabelCacheItem labelItem, Graphics2D graphics, TextLayout layout) {
        double wordSpacing = labelItem.getWordSpacing();
        if (text.trim().indexOf(32) == -1 || wordSpacing <= 0.0) {
            LineInfo.LineComponent component = new LineInfo.LineComponent(text, this.layoutSentence(text, labelItem, graphics, font), layout);
            return Arrays.asList(component);
        }
        String[] parts = WORD_SPLITTER.split(text);
        ArrayList<LineInfo.LineComponent> result = new ArrayList<LineInfo.LineComponent>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            LineInfo.LineComponent component = new LineInfo.LineComponent(part, this.layoutSentence(part, labelItem, graphics, font), layout);
            result.add(component);
            if (i >= parts.length - 1) continue;
            double tracking = wordSpacing / (double)font.getSize();
            Font spacerFont = font.deriveFont(Collections.singletonMap(TextAttribute.TRACKING, tracking));
            TextLayout spacerLayout = new TextLayout(SINGLE_CHAR_STRING, spacerFont, graphics.getFontRenderContext());
            LineInfo.LineComponent spacer = new LineInfo.LineComponent(SINGLE_CHAR_STRING, this.layoutSentence(SINGLE_CHAR_STRING, labelItem, graphics, spacerFont), spacerLayout);
            result.add(spacer);
        }
        return result;
    }

    private List<FontRange> getLineRanges(List<FontRange> ranges, int prevPosition, int newPosition) {
        int start = -1;
        int end = ranges.size();
        for (int i = 0; i < ranges.size(); ++i) {
            FontRange range = ranges.get(i);
            if (start == -1) {
                if (range.endChar <= prevPosition) continue;
                start = i;
            }
            if (range.startChar <= newPosition) continue;
            end = i;
            break;
        }
        return ranges.subList(start, end);
    }

    private AttributedString buildAttributedLine(String line, List<FontRange> ranges) {
        if (ranges.size() == 1) {
            HashMap<TextAttribute, Font> map = new HashMap<TextAttribute, Font>();
            map.put(TextAttribute.FONT, ranges.get((int)0).font);
            AttributedString as = new AttributedString(line, map);
            return as;
        }
        AttributedString as = new AttributedString(line);
        for (FontRange range : ranges) {
            as.addAttribute(TextAttribute.FONT, range.font, range.startChar, range.endChar);
        }
        return as;
    }

    private String checkForEmptyLine(String line) {
        if (line == null || line.equals("")) {
            return SINGLE_CHAR_STRING;
        }
        return line;
    }

    GlyphVector layoutSentence(String label, LabelCacheItem item, Graphics2D graphics, Font font) {
        int length;
        char[] chars = label.toCharArray();
        if (Bidi.requiresBidi(chars, 0, length = label.length())) {
            Bidi bidi = new Bidi(label, -2);
            if (bidi.isRightToLeft()) {
                return font.layoutGlyphVector(graphics.getFontRenderContext(), chars, 0, length, 1);
            }
            if (bidi.isMixed()) {
                String r = "";
                for (int i = 0; i < bidi.getRunCount(); ++i) {
                    String s1 = label.substring(bidi.getRunStart(i), bidi.getRunLimit(i));
                    if (bidi.getRunLevel(i) % 2 == 0) {
                        s1 = new StringBuffer(s1).reverse().toString();
                    }
                    r = r + s1;
                }
                char[] chars2 = r.toCharArray();
                return font.layoutGlyphVector(graphics.getFontRenderContext(), chars2, 0, length, 1);
            }
        }
        return font.layoutGlyphVector(graphics.getFontRenderContext(), chars, 0, chars.length, 0);
    }

    List<FontRange> buildFontRanges(String text, Font[] fonts) {
        if (fonts.length == 1) {
            return Arrays.asList(new FontRange(text, 0, text.length(), fonts[0]));
        }
        ArrayList<FontRange> result = new ArrayList<FontRange>();
        int start = 0;
        int lastSupportedChar = 0;
        char[] chars = text.toCharArray();
        while (start < chars.length) {
            int i = 0;
            while (i < fonts.length) {
                Font font = fonts[i];
                int newPosition = font.canDisplayUpTo(chars, start, chars.length);
                if (newPosition == -1) {
                    result.add(new FontRange(text, start, chars.length, font));
                    lastSupportedChar = start = chars.length;
                    break;
                }
                if (newPosition > start) {
                    result.add(new FontRange(text, start, newPosition, font));
                    lastSupportedChar = start = newPosition;
                    if (i <= 0) continue;
                    i = 0;
                    continue;
                }
                ++i;
            }
            if (start >= chars.length) continue;
            int base = start++;
            boolean foundFont = false;
            while (start < chars.length && !foundFont) {
                char curr = chars[start];
                for (int i2 = 0; i2 < fonts.length; ++i2) {
                    Font font = fonts[i2];
                    if (!font.canDisplay(curr)) continue;
                    foundFont = true;
                    result.add(new FontRange(text, base, start, fonts[0]));
                    break;
                }
                if (foundFont) continue;
                ++start;
            }
        }
        if (lastSupportedChar < chars.length) {
            result.add(new FontRange(text, lastSupportedChar, chars.length, fonts[0]));
        }
        return result;
    }

    static class FontRange {
        int startChar;
        int endChar;
        Font font;
        String text;

        public FontRange(String fullText, int startChar, int endChar, Font font) {
            this.text = fullText.substring(startChar, endChar);
            this.startChar = startChar;
            this.endChar = endChar;
            this.font = font;
        }

        public String toString() {
            return "FontRange [font=" + this.font + ", text=" + this.text + "]";
        }
    }
}

