/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.Util;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.services.getrecords.FieldMapper;
import org.fao.geonet.kernel.csw.services.getrecords.FilterParser;
import org.fao.geonet.kernel.csw.services.getrecords.es.CswFilter2Es;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchController {
    public static final String DEFAULT_ELEMENTNAMES_STRATEGY = "relaxed";
    @Autowired
    NodeInfo node;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    private EsSearchManager searchManager;
    @Autowired
    private FieldMapper fieldMapper;
    @Autowired
    private EsFilterBuilder esFilterBuilder;
    @Autowired
    private SchemaManager schemaManager;

    public static Element retrieveMetadata(ServiceContext context, String id, ElementSetName setName, String outSchema, Set<String> elemNames, String typeName, ResultType resultType, String strategy, String displayLanguage) throws CatalogException {
        try {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            boolean forEditing = false;
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            Element res = ((DataManager)gc.getBean(DataManager.class)).getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
            SchemaManager scm = (SchemaManager)gc.getBean(SchemaManager.class);
            if (res == null) {
                return null;
            }
            Element info = res.getChild("info", Edit.NAMESPACE);
            String schema = info.getChildText("schema");
            Attribute schemaLocAtt = scm.getSchemaLocation(schema, context);
            if (schemaLocAtt != null && res.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
                res.setAttribute(schemaLocAtt);
                res.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
                res.addNamespaceDeclaration(schemaLocAtt.getNamespace());
            }
            res = org.fao.geonet.csw.common.util.Xml.applyElementSetName(context, scm, schema, res, outSchema, setName, resultType, id, displayLanguage);
            res = SearchController.applyElementNames(context, elemNames, typeName, scm, schema, res, resultType, info, strategy);
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("SearchController:retrieveMetadata: before applying postprocessing on metadata Element for id " + id));
            }
            res = SearchController.applyPostProcessing(context, scm, schema, res, outSchema, setName, resultType, id, displayLanguage);
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("SearchController:retrieveMetadata: All processing is complete on metadata Element for id " + id));
            }
            if (res != null) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)("SearchController returns\n" + Xml.getString((Element)res)));
                }
            } else if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)"SearchController returns null");
            }
            return res;
        }
        catch (InvalidParameterValueEx e) {
            throw e;
        }
        catch (Exception e) {
            context.error("Error while getting metadata with id : " + id);
            context.error("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e));
            throw new NoApplicableCodeEx("Raised exception while getting metadata :" + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element applyElementNames(ServiceContext context, Set<String> elementNames, String typeName, SchemaManager schemaManager, String schema, Element result, ResultType resultType, Element info, String strategy) throws InvalidParameterValueEx {
        if (elementNames != null) {
            if (StringUtils.isEmpty((String)strategy)) {
                strategy = DEFAULT_ELEMENTNAMES_STRATEGY;
            }
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("SearchController dealing with # " + elementNames.size() + " elementNames using strategy " + strategy));
            }
            MetadataSchema mds = schemaManager.getSchema(schema);
            List namespaces = mds.getSchemaNS();
            Element matchingMetadata = (Element)result.clone();
            if (strategy.equals("context") || strategy.equals("geonetwork26")) {
                matchingMetadata.removeContent();
            }
            boolean metadataContainsAllRequestedElementNames = true;
            ArrayList nodes = new ArrayList();
            for (String elementName : elementNames) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)("SearchController dealing with elementName: " + elementName));
                }
                try {
                    String xpath;
                    if (elementName.startsWith("/")) {
                        xpath = elementName;
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("elementname start with root: " + elementName));
                        }
                    } else if (elementName.startsWith("csw:Record") || elementName.startsWith("gmd:MD_Metadata")) {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("elementname starts with one of the supported typeNames : " + elementName));
                        }
                        xpath = "/" + elementName;
                    } else {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("elementname does not start with one of the supported typeNames : " + elementName));
                        }
                        xpath = "/" + typeName + "//" + elementName;
                    }
                    ArrayList<Element> elementsMatching = Xml.selectDocumentNodes((Element)result, (String)xpath, (List)namespaces);
                    if (strategy.equals("context")) {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)"strategy is context, constructing context to root");
                        }
                        ArrayList<Element> elementsInContextMatching = new ArrayList<Element>();
                        for (Element match : elementsMatching) {
                            for (Element parent = match.getParentElement(); parent != null; parent = parent.getParentElement()) {
                                parent.removeContent();
                                parent.addContent((Content)((Element)match.clone()));
                                match = (Element)parent.clone();
                            }
                            elementsInContextMatching.add(match);
                        }
                        elementsMatching = elementsInContextMatching;
                    }
                    nodes.addAll(elementsMatching);
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)("elemName " + elementName + " matched # " + nodes.size() + " nodes"));
                    }
                    if (nodes.size() != 0) continue;
                    metadataContainsAllRequestedElementNames = false;
                    break;
                }
                catch (Exception x) {
                    Log.error((String)"geonetwork.csw.search", (Object)x.getMessage(), (Throwable)x);
                    throw new InvalidParameterValueEx("elementName has invalid XPath : " + elementName, x.getMessage());
                }
            }
            if (metadataContainsAllRequestedElementNames) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)"metadata containa all requested elementnames: included in response");
                }
                if (strategy.equals("context") || strategy.equals("geonetwork26")) {
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)"adding only the matching fragments to result");
                    }
                    Iterator<String> iterator = nodes.iterator();
                    while (iterator.hasNext()) {
                        Element node = (Element)iterator.next();
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("adding node:\n" + Xml.getString((Element)node)));
                        }
                        matchingMetadata.addContent((Content)node.clone());
                    }
                    return matchingMetadata;
                }
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)"adding the complete metadata to results");
                }
                if (strategy.equals("csw202")) {
                    GeonetContext geonetContext = (GeonetContext)context.getHandlerContext("contextName");
                    DataManager dataManager = (DataManager)geonetContext.getBean(DataManager.class);
                    boolean valid = dataManager.validate(result);
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)("strategy csw202: only valid metadata is returned. This one is valid? " + valid));
                    }
                    if (!valid) {
                        return null;
                    }
                }
                matchingMetadata = result;
                return matchingMetadata;
            }
            if (!Log.isDebugEnabled((String)"geonetwork.csw.search")) return null;
            Log.debug((String)"geonetwork.csw.search", (Object)"metadata does not contain all requested elementnames: not included in response");
            return null;
        }
        if (!Log.isDebugEnabled((String)"geonetwork.csw.search")) return result;
        Log.debug((String)"geonetwork.csw.search", (Object)"No ElementNames to apply");
        return result;
    }

    public Element search(ServiceContext context, int startPos, int maxRecords, ResultType resultType, String outSchema, ElementSetName setName, Element filterExpr, String filterVersion, List<SortBuilder<FieldSortBuilder>> sort, Set<String> elemNames, String typeName, int maxHitsFromSummary, String strategy) throws CatalogException {
        JsonNode esJsonQuery;
        String elasticSearchQuery = this.convertCswFilterToEsQuery(filterExpr, filterVersion);
        try {
            String filterQueryString = EsFilterBuilder.build((ServiceContext)context, (String)"metadata", (boolean)false, (NodeInfo)this.node);
            String jsonQuery = String.format(elasticSearchQuery, filterQueryString);
            ObjectMapper objectMapper = new ObjectMapper();
            esJsonQuery = objectMapper.readTree(jsonQuery);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Element results = new Element("SearchResults", Csw.NAMESPACE_CSW);
        try {
            SearchResponse result = this.searchManager.query(esJsonQuery, new HashSet(), startPos - 1, maxRecords, sort);
            SearchHit[] hits = result.getHits().getHits();
            long numMatches = result.getHits().getTotalHits().value;
            if (numMatches != 0L && (long)startPos > numMatches) {
                throw new InvalidParameterValueEx("startPosition", String.format("Start position (%d) can't be greater than number of matching records (%d for current search).", startPos, numMatches));
            }
            int counter = 0;
            for (SearchHit hit : hits) {
                int mdId = Integer.parseInt((String)hit.getSourceAsMap().get("id"));
                AbstractMetadata metadata = this.metadataUtils.findOne(mdId);
                String displayLanguage = context.getLanguage();
                Element resultMD = SearchController.retrieveMetadata(context, metadata.getId() + "", setName, outSchema, elemNames, typeName, resultType, strategy, displayLanguage);
                if (resultMD == null) continue;
                if (resultType == ResultType.RESULTS) {
                    results.addContent((Content)resultMD);
                }
                ++counter;
            }
            results.setAttribute("numberOfRecordsMatched", Long.toString(numMatches));
            results.setAttribute("numberOfRecordsReturned", Long.toString(counter));
            results.setAttribute("elementSet", setName.toString());
            if (numMatches > (long)counter) {
                results.setAttribute("nextRecord", Long.toString(counter + startPos));
            } else {
                results.setAttribute("nextRecord", "0");
            }
            return results;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Element applyElementSetName(ServiceContext context, SchemaManager schemaManager, String schema, Element result, String outputSchema, ElementSetName elementSetName, ResultType resultType, String id, String displayLanguage) throws InvalidParameterValueEx {
        Path schemaDir = schemaManager.getSchemaCSWPresentDir(schema);
        Path styleSheet = schemaDir.resolve(outputSchema + "-" + (Object)((Object)elementSetName) + ".xsl");
        if (!Files.exists(styleSheet, new LinkOption[0])) {
            context.warning(String.format("OutputSchema '%s' not supported for metadata with '%s' (%s). Corresponding XSL transformation '%s' does not exist. The record will not be returned in response.", outputSchema, id, schema, styleSheet.toString()));
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lang", displayLanguage);
        try {
            result = Xml.transform((Element)result, (Path)styleSheet, params);
        }
        catch (Exception e) {
            context.error("Error while transforming metadata with id : " + id + " using " + styleSheet);
            context.error("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e));
            return null;
        }
        return result;
    }

    private String convertCswFilterToEsQuery(Element xml, String filterVersion) {
        return CswFilter2Es.translate(FilterParser.parseFilter(xml, filterVersion), this.fieldMapper);
    }

    private static Element applyPostProcessing(ServiceContext context, SchemaManager schemaManager, String schema, Element result, String outputSchema, ElementSetName elementSetName, ResultType resultType, String id, String displayLanguage) throws InvalidParameterValueEx {
        Path schemaDir = schemaManager.getSchemaCSWPresentDir(schema);
        NodeInfo nodeInfo = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        Path styleSheet = schemaDir.resolve(outputSchema + "-" + (context.getService().equals("csw") ? nodeInfo.getId() : context.getService()) + "-postprocessing.xsl");
        if (Files.exists(styleSheet, new LinkOption[0])) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("lang", displayLanguage);
            try {
                result = Xml.transform((Element)result, (Path)styleSheet, params);
            }
            catch (Exception e) {
                context.error("Error while transforming metadata with id : " + id + " using " + styleSheet);
                context.error("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e));
                return null;
            }
        }
        return result;
    }
}

