/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

public class Lock {
    public static final String TAG_NAME = "activelock";
    public static final int TYPE_WRITE = 0;
    public static final int TYPE_TRANSACTION = 1;
    public static final int SCOPE_EXCLUSIVE = 0;
    public static final int SCOPE_SHARED = 1;
    protected int lockScope = -1;
    protected int lockType = -1;
    protected int depth = -1;
    protected String owner = null;
    protected int timeout = -1;
    protected String lockToken = null;
    protected String principalUrl = null;

    public Lock(int lockScope, int lockType) {
        this.lockScope = lockScope;
        this.lockType = lockType;
    }

    public Lock(int lockScope, int lockType, int depth, String owner, int timeout, String lockToken) {
        this.lockScope = lockScope;
        this.lockType = lockType;
        this.depth = depth;
        this.owner = owner;
        this.timeout = timeout;
        this.lockToken = lockToken;
    }

    public Lock(int lockScope, int lockType, int depth, String owner, int timeout, String lockToken, String principalUrl) {
        this.lockScope = lockScope;
        this.lockType = lockType;
        this.depth = depth;
        this.owner = owner;
        this.timeout = timeout;
        this.lockToken = lockToken;
        this.principalUrl = principalUrl;
    }

    public Lock(int lockScope, int lockType, int depth, String owner, long timeout, String lockToken) {
        this(lockScope, lockType, depth, owner, (int)timeout, lockToken);
    }

    public int getLockScope() {
        return this.lockScope;
    }

    public int getLockType() {
        return this.lockType;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getPrincipalUrl() {
        return this.principalUrl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        if (this.lockScope == 0) {
            tmp.append("Exclusive");
        } else if (this.lockScope == 1) {
            tmp.append("Shared");
        }
        if (this.lockType == 0) {
            tmp.append(" write lock");
        }
        if (this.depth == Integer.MAX_VALUE) {
            tmp.append(" depth:infinity");
        } else if (this.depth != -1) {
            tmp.append(" depth:" + this.depth);
        }
        if (this.owner != null) {
            tmp.append(" owner:" + this.owner);
        }
        if (this.timeout != -1) {
            tmp.append(" timeout:" + this.timeout);
        }
        if (this.lockToken != null) {
            tmp.append(" token:" + this.lockToken);
        }
        return tmp.toString();
    }
}

