/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.io.Serializable;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class StatementImpl
implements Statement,
Serializable {
    private Resource _subject;
    private URI _predicate;
    private Value _object;

    public StatementImpl(Resource subject, URI predicate, Value object) {
        this._subject = subject;
        this._predicate = predicate;
        this._object = object;
    }

    public Resource getSubject() {
        return this._subject;
    }

    public URI getPredicate() {
        return this._predicate;
    }

    public Value getObject() {
        return this._object;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Statement) {
            Statement otherSt = (Statement)other;
            return this._object.equals(otherSt.getObject()) && this._subject.equals(otherSt.getSubject()) && ((Object)this._predicate).equals(otherSt.getPredicate());
        }
        return false;
    }

    public int hashCode() {
        return this._subject.hashCode() & 0xFF0000 | ((Object)this._predicate).hashCode() & 0xFF00 | this._object.hashCode() & 0xFF;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        Statement other = (Statement)o;
        int result = 0;
        result = this._object.compareTo(other.getObject());
        if (result == 0) {
            result = this._subject.compareTo(other.getSubject());
        }
        if (result == 0) {
            result = this._predicate.compareTo(other.getPredicate());
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("(");
        result.append(this._subject.toString());
        result.append(", ");
        result.append(this._predicate.toString());
        result.append(", ");
        result.append(this._object.toString());
        result.append(")");
        return result.toString();
    }
}

