/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.security.openid.JwtDecoder;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdCredentials
implements Serializable {
    private static final Logger LOG = Log.getLogger(OpenIdCredentials.class);
    private static final long serialVersionUID = 4766053233370044796L;
    private final String redirectUri;
    private String authCode;
    private Map<String, Object> response;
    private Map<String, Object> claims;
    private boolean verified = false;

    public OpenIdCredentials(Map<String, Object> claims) {
        this.redirectUri = null;
        this.authCode = null;
        this.claims = claims;
    }

    public OpenIdCredentials(String authCode, String redirectUri) {
        this.authCode = authCode;
        this.redirectUri = redirectUri;
    }

    public String getUserId() {
        return (String)this.claims.get("sub");
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public Map<String, Object> getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeemAuthCode(OpenIdConfiguration configuration) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("redeemAuthCode() {}", new Object[]{this});
        }
        if (this.authCode != null) {
            try {
                String idToken;
                this.response = this.claimAuthCode(configuration);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: {}", new Object[]{this.response});
                }
                if ((idToken = (String)this.response.get("id_token")) == null) {
                    throw new AuthenticationException("no id_token");
                }
                String accessToken = (String)this.response.get("access_token");
                if (accessToken == null) {
                    throw new AuthenticationException("no access_token");
                }
                String tokenType = (String)this.response.get("token_type");
                if (!"Bearer".equalsIgnoreCase(tokenType)) {
                    throw new AuthenticationException("invalid token_type");
                }
                this.claims = JwtDecoder.decode(idToken);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("claims {}", new Object[]{this.claims});
                }
            }
            finally {
                this.authCode = null;
            }
        }
        if (!this.verified) {
            this.validateClaims(configuration);
            this.verified = true;
        }
    }

    private void validateClaims(OpenIdConfiguration configuration) throws Exception {
        if (!configuration.getIssuer().equals(this.claims.get("iss"))) {
            throw new AuthenticationException("Issuer Identifier MUST exactly match the iss Claim");
        }
        this.validateAudience(configuration);
        Object azp = this.claims.get("azp");
        if (azp != null && !configuration.getClientId().equals(azp)) {
            throw new AuthenticationException("Authorized party claim value should be the client_id");
        }
        long expiry = (Long)this.claims.get("exp");
        long currentTimeSeconds = (long)((float)System.currentTimeMillis() / 1000.0f);
        if (currentTimeSeconds > expiry) {
            throw new AuthenticationException("ID Token has expired");
        }
    }

    private void validateAudience(OpenIdConfiguration configuration) throws AuthenticationException {
        boolean isValidType;
        Object aud = this.claims.get("aud");
        String clientId = configuration.getClientId();
        boolean isString = aud instanceof String;
        boolean isList = aud instanceof Object[];
        boolean bl = isValidType = isString || isList;
        if (isString && !clientId.equals(aud)) {
            throw new AuthenticationException("Audience Claim MUST contain the client_id value");
        }
        if (isList) {
            List<Object> list = Arrays.asList((Object[])aud);
            if (!list.contains(clientId)) {
                throw new AuthenticationException("Audience Claim MUST contain the client_id value");
            }
            if (list.size() > 1 && this.claims.get("azp") == null) {
                throw new AuthenticationException("A multi-audience ID token needs to contain an azp claim");
            }
        } else if (!isValidType) {
            throw new AuthenticationException("Audience claim was not valid");
        }
    }

    private Map<String, Object> claimAuthCode(OpenIdConfiguration configuration) throws Exception {
        Object parsedResponse;
        Fields fields = new Fields();
        fields.add("code", this.authCode);
        fields.add("redirect_uri", this.redirectUri);
        fields.add("grant_type", "authorization_code");
        Request request = configuration.getHttpClient().POST(configuration.getTokenEndpoint());
        switch (configuration.getAuthMethod()) {
            case "client_secret_basic": {
                URI uri = URI.create(configuration.getTokenEndpoint());
                BasicAuthentication.BasicResult authentication = new BasicAuthentication.BasicResult(uri, configuration.getClientId(), configuration.getClientSecret());
                authentication.apply(request);
                break;
            }
            case "client_secret_post": {
                fields.add("client_id", configuration.getClientId());
                fields.add("client_secret", configuration.getClientSecret());
                break;
            }
            default: {
                throw new IllegalStateException(configuration.getAuthMethod());
            }
        }
        FormContentProvider formContent = new FormContentProvider(fields);
        request = request.content((ContentProvider)formContent).timeout(10L, TimeUnit.SECONDS);
        ContentResponse response = request.send();
        String responseBody = response.getContentAsString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication response: {}", new Object[]{responseBody});
        }
        if (!((parsedResponse = JSON.parse((String)responseBody)) instanceof Map)) {
            throw new AuthenticationException("Malformed response from OpenID Provider");
        }
        return (Map)parsedResponse;
    }

    public static class AuthenticationException
    extends Exception {
        public AuthenticationException(String message) {
            super(message);
        }
    }
}

