/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.handlers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ParseSQSErrorFromXmlContent
extends ParseAWSErrorFromXmlContent {
    protected Set<String> resourceNotFoundCodes = ImmutableSet.of((Object)"AWS.SimpleQueueService.NonExistentQueue");
    protected Set<String> illegalStateCodes = ImmutableSet.of((Object)"AWS.SimpleQueueService.QueueDeletedRecently", (Object)"AWS.SimpleQueueService.QueueNameExists");
    protected Set<String> illegalArgumentCodes = ImmutableSet.of((Object)"InvalidAttributeName", (Object)"ReadCountOutOfRange", (Object)"InvalidMessageContents", (Object)"MessageTooLong");

    @Inject
    public ParseSQSErrorFromXmlContent(AWSUtils utils) {
        super(utils);
    }

    protected Exception refineException(HttpCommand command, HttpResponse response, Exception exception, AWSError error, String message) {
        String errorCode;
        String string = errorCode = error != null && error.getCode() != null ? error.getCode() : null;
        exception = this.resourceNotFoundCodes.contains(errorCode) ? new ResourceNotFoundException(message, (Throwable)exception) : (this.illegalStateCodes.contains(errorCode) ? new IllegalStateException(message, exception) : (this.illegalArgumentCodes.contains(errorCode) ? new IllegalArgumentException(message, exception) : super.refineException(command, response, exception, error, message)));
        return exception;
    }
}

