/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.QueryResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.BinaryTableResultWriter;
import org.openrdf.sesame.query.HtmlTableWriter;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.VarBindingRdfWriter;
import org.openrdf.sesame.query.XmlQueryResultWriter;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class TableQueryServlet
extends SesameServlet {
    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"repository");
        String query = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"query");
        String queryLanguageStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"queryLanguage");
        String resultFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"resultFormat", (String)QueryResultFormat.XML.toString());
        String serializationStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"serialization", (String)RDFFormat.RDFXML.toString());
        String plainXMLLiteralsStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"plainXMLLiterals", (String)"off");
        this._handleRequest(request, response, repository, query, queryLanguageStr, resultFormatStr, serializationStr, plainXMLLiteralsStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String repository = HttpServerUtil.getParameter((Map)fileItemMap, (String)"repository");
        String query = HttpServerUtil.getParameter((Map)fileItemMap, (String)"query");
        String queryLanguageStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"queryLanguage");
        String resultFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"resultFormat", (String)QueryResultFormat.XML.toString());
        String serializationStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"serialization", (String)RDFFormat.RDFXML.toString());
        String plainXMLLiteralsStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"plainXMLLiterals", (String)"off");
        this._handleRequest(request, response, repository, query, queryLanguageStr, resultFormatStr, serializationStr, plainXMLLiteralsStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String query, String queryLanguageStr, String resultFormatStr, String serializationStr, String plainXMLLiteralsStr) throws IOException {
        HTTPOutputStream httpOut;
        TableQueryResultListener resListener;
        QueryLanguage queryLanguage;
        block18: {
            QueryResultFormat resultFormat;
            block21: {
                RDFFormat serialization;
                block22: {
                    block20: {
                        block19: {
                            SesameServer.setThreadLogFileForRepository(repository);
                            this._logIP(request);
                            ThreadLog.log((String)">>> evaluate table query");
                            ThreadLog.trace((String)("query = " + query));
                            ThreadLog.trace((String)("queryLanguage = " + queryLanguageStr));
                            ThreadLog.trace((String)("repository = " + repository));
                            ThreadLog.trace((String)("resultFormat = " + resultFormatStr));
                            ThreadLog.trace((String)("serialization = " + serializationStr));
                            ThreadLog.trace((String)("plainXMLLiterals = " + plainXMLLiteralsStr));
                            if (query == null) {
                                this._sendBadRequest("Query is missing", response);
                                return;
                            }
                            if (repository == null) {
                                this._sendBadRequest("No repository specified", response);
                                return;
                            }
                            if (queryLanguageStr == null) {
                                this._sendBadRequest("Query language not specified", response);
                                return;
                            }
                            queryLanguage = QueryLanguage.forValue(queryLanguageStr);
                            if (queryLanguage == null) {
                                this._sendBadRequest("Unsupported query language: " + queryLanguageStr, response);
                                return;
                            }
                            boolean plainXMLLiterals = plainXMLLiteralsStr.equals("on");
                            resListener = null;
                            resultFormat = QueryResultFormat.forValue(resultFormatStr);
                            httpOut = new HTTPOutputStream(response);
                            httpOut.setUseGZIPCompression(HttpServerUtil.acceptsGZIPEncoding((HttpServletRequest)request));
                            httpOut.setCacheableResult(false);
                            if (resultFormat != QueryResultFormat.XML) break block19;
                            httpOut.setContentType("text/xml; charset=utf-8");
                            resListener = new XmlQueryResultWriter(httpOut, plainXMLLiterals);
                            break block18;
                        }
                        if (resultFormat != QueryResultFormat.HTML) break block20;
                        httpOut.setContentType("text/html");
                        String styleSheetURL = request.getContextPath() + "/query.css";
                        resListener = new HtmlTableWriter(httpOut, repository, styleSheetURL);
                        break block18;
                    }
                    if (resultFormat != QueryResultFormat.RDF) break block21;
                    serialization = RDFFormat.forValue(serializationStr);
                    if (serialization != RDFFormat.RDFXML) break block22;
                    httpOut.setContentType("application/rdf+xml; charset=utf-8");
                    resListener = new VarBindingRdfWriter(serialization, httpOut);
                    break block18;
                }
                if (serialization == RDFFormat.TURTLE) {
                    httpOut.setContentType("application/x-turtle");
                    resListener = new VarBindingRdfWriter(serialization, httpOut);
                    break block18;
                } else if (serialization == RDFFormat.NTRIPLES) {
                    httpOut.setContentType("text/plain");
                    resListener = new VarBindingRdfWriter(serialization, httpOut);
                    break block18;
                } else {
                    if (serialization != RDFFormat.N3) {
                        this._sendBadRequest("Unknown serialization format: " + serializationStr, response);
                        return;
                    }
                    httpOut.setContentType("text/rdf+n3");
                    resListener = new VarBindingRdfWriter(serialization, httpOut);
                }
                break block18;
            }
            if (resultFormat != QueryResultFormat.BINARY) {
                this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
                return;
            }
            httpOut.setContentType("application/x-binary-rdf-results-table");
            resListener = new BinaryTableResultWriter(httpOut);
        }
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep = service.getRepository(repository);
            rep.performTableQuery(queryLanguage, query, resListener);
            httpOut.close();
            return;
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
            return;
        }
        catch (AccessDeniedException e) {
            this._sendForbidden(e.getMessage(), response);
            return;
        }
        catch (MalformedQueryException e) {
            this._sendBadRequest(HTTPErrorType.MALFORMED_QUERY, e.getMessage(), response);
            return;
        }
        catch (QueryEvaluationException e) {
            ThreadLog.warning((String)("Query evaluation error: " + e.getMessage()));
            if (!httpOut.streamOpened()) {
                this._sendBadRequest(HTTPErrorType.QUERY_EVALUATION_ERROR, e.getMessage(), response);
                return;
            }
            resListener.error(QueryErrorType.QUERY_EVALUATION_ERROR, e.getMessage());
            resListener.endTableQueryResult();
            return;
        }
        catch (IOException e) {
            ThreadLog.warning((String)("I/O error, client connection closed?\n" + e.getMessage()));
            return;
        }
        catch (Exception e) {
            ThreadLog.error((String)("Unknown error on query: " + query), (Object)e);
            resListener.error(QueryErrorType.QUERY_EVALUATION_ERROR, "The server generated an unknown error. Please inform the server administrator.");
            resListener.endTableQueryResult();
        }
    }
}

