/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.util.StringUtil;

public class SQLServer
extends RDBMS {
    public SQLServer() {
        this.ID_INT = "int";
        this.LOCALNAME = "nvarchar(255)";
        this.LANGUAGE = "varchar(16)";
        this.LABEL = "nvarchar(4000)";
        this.LABEL_TYPE = 12;
        this.LABEL_HASH = "bigint";
        this.PREFIX = "nvarchar(16)";
        this.NAME = "nvarchar(4000)";
        this.NAME_TYPE = 12;
        this.BOOLEAN = "tinyint";
        this.BOOLEAN_TYPE = -6;
        this.TRUE = "1";
        this.FALSE = "0";
        this.INFOFIELD = "varchar(255)";
    }

    public void optimizeTable(String tableName) throws SQLException {
    }

    protected void _clearTable(String tableName) throws SQLException {
        this.executeUpdate("TRUNCATE TABLE " + tableName);
    }

    protected void _renameTable(String currentTableName, String newTableName) throws SQLException {
        Connection con = this.getConnection();
        CallableStatement callSt = con.prepareCall("{call sp_rename(?,?)}");
        callSt.setString(1, currentTableName);
        callSt.setString(2, newTableName);
        callSt.executeUpdate();
    }

    public void renameTableColumn(String tableName, String currentColumnName, String newColumnName, String columnSignature) throws SQLException {
        this.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + newColumnName + " " + columnSignature);
        this.executeUpdate("UPDATE " + tableName + " SET " + newColumnName + " = " + currentColumnName);
        this.executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN " + currentColumnName);
    }

    public String escapeString(String s) {
        return StringUtil.gsub((String)"'", (String)"''", (String)s);
    }
}

