/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf.datastore;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.TransferUtil;

public class DataFile {
    private static final long HEADER_LENGTH = 4L;
    private File _file;
    private RandomAccessFile _raf;
    private FileChannel _fileChannel;
    private File _txnFile;
    private RandomAccessFile _txnRaf;
    private FileChannel _txnChannel;
    private boolean _isolatedTransaction;
    private boolean _dataCleared;

    public DataFile(File file) throws IOException {
        this._file = file;
        this._file.createNewFile();
        this._raf = new RandomAccessFile(file, "rw");
        this._fileChannel = this._raf.getChannel();
        if (this._fileChannel.size() == 0L) {
            this._fileChannel.write(ByteBuffer.wrap(new byte[]{0, 0, 0, 0}));
        }
    }

    public void startTransaction(boolean isolateTransaction) throws IOException {
        this._isolatedTransaction = isolateTransaction;
        if (isolateTransaction) {
            this._txnFile = new File(this._file.getParentFile(), "txn_" + this._file.getName());
            this._txnFile.createNewFile();
            this._txnRaf = new RandomAccessFile(this._txnFile, "rw");
            this._txnChannel = this._txnRaf.getChannel();
            this._txnChannel.truncate(0L);
            this._dataCleared = false;
        }
    }

    public void commitTransaction() throws IOException {
        if (this._isolatedTransaction) {
            if (this._dataCleared) {
                this._fileChannel.truncate(4L);
            }
            this._txnChannel.position(0L);
            TransferUtil.transferFrom(this._txnChannel, this._fileChannel.size(), this._txnChannel.size(), this._fileChannel);
            this._txnRaf.close();
            this._txnRaf = null;
            this._txnChannel = null;
            this._txnFile.delete();
            this._txnFile = null;
        }
        this._fileChannel.force(false);
    }

    public void rollbackTransaction() throws IOException {
        if (!this._isolatedTransaction) {
            throw new IOException("Unisolated transactions cannot be rolled back");
        }
        this._txnRaf.close();
        this._txnRaf = null;
        this._txnChannel = null;
        this._txnFile.delete();
        this._txnFile = null;
    }

    public long storeData(byte[] data) throws IOException {
        if (this._isolatedTransaction) {
            long offset = this._txnChannel.size();
            this._writeData(this._txnChannel, offset, data);
            if (this._dataCleared) {
                return 4L + offset;
            }
            return this._fileChannel.size() + offset;
        }
        long offset = this._fileChannel.size();
        this._writeData(this._fileChannel, offset, data);
        return offset;
    }

    public void updateData(long offset, byte[] data) throws IOException {
        FileChannel channel = this._fileChannel;
        if (this._isolatedTransaction && (this._dataCleared || offset >= this._fileChannel.size())) {
            channel = this._txnChannel;
            offset -= this._dataCleared ? 4L : this._fileChannel.size();
        }
        this._writeData(channel, offset, data);
    }

    private void _writeData(FileChannel channel, long offset, byte[] data) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(data.length + 4);
        buf.putInt(data.length);
        buf.put(data);
        buf.rewind();
        channel.write(buf, offset);
    }

    public byte[] getData(long offset, boolean dirtyReads) throws IOException {
        FileChannel channel = this._fileChannel;
        if (dirtyReads && this._isolatedTransaction && (this._dataCleared || offset >= this._fileChannel.size())) {
            channel = this._txnChannel;
            offset -= this._dataCleared ? 4L : this._fileChannel.size();
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        channel.read(buf, offset);
        int dataLength = buf.getInt(0);
        byte[] data = new byte[dataLength];
        buf = ByteBuffer.wrap(data);
        channel.read(buf, offset + 4L);
        return data;
    }

    public void clear() throws IOException {
        if (this._isolatedTransaction) {
            this._txnChannel.truncate(0L);
            this._dataCleared = true;
        } else {
            this._fileChannel.truncate(4L);
        }
    }

    public void close() throws IOException {
        if (this._txnChannel != null) {
            this.rollbackTransaction();
        }
        this._raf.close();
    }

    public DataIterator iterator() {
        return new DataIterator();
    }

    public class DataIterator {
        private long _position = 4L;

        public boolean hasNext() throws IOException {
            return this._position < DataFile.this._fileChannel.size();
        }

        public byte[] next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] data = DataFile.this.getData(this._position, false);
            this._position += (long)(4 + data.length);
            return data;
        }
    }
}

