/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.simpleUrl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transactional;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.simpleUrl.SimpleUrlParams;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.jdom.Element;

public class Aligner
extends BaseAligner<SimpleUrlParams> {
    private ServiceContext context;
    private DataManager dataMan;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UUIDMapper localUuids;
    private IMetadataUtils metadataUtils;
    private IMetadataManager metadataManager;
    private IMetadataIndexer metadataIndexer;
    private HarvestResult result;
    private Map<String, Object> processParams = new HashMap<String, Object>();
    private Logger log;

    public Aligner(AtomicBoolean cancelMonitor, ServiceContext sc, SimpleUrlParams params, Logger log) throws OperationAbortedEx {
        super(cancelMonitor);
        this.context = sc;
        this.params = params;
        this.log = log;
        GeonetContext gc = (GeonetContext)this.context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataUtils = (IMetadataUtils)gc.getBean(IMetadataUtils.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.metadataIndexer = (IMetadataIndexer)gc.getBean(IMetadataIndexer.class);
        this.result = new HarvestResult();
        this.result.unretrievable = 0;
        this.result.uuidSkipped = 0;
        this.result.couldNotInsert = 0;
    }

    public HarvestResult align(Map<String, Element> records, Collection<HarvestError> errors) throws Exception {
        if (this.cancelMonitor.get()) {
            return this.result;
        }
        this.log.debug("Start of alignment for : " + ((SimpleUrlParams)this.params).getName());
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((SimpleUrlParams)this.params).getUuid());
        this.insertOrUpdate(records, errors);
        this.log.debug("End of alignment for : " + ((SimpleUrlParams)this.params).getName());
        return this.result;
    }

    private void insertOrUpdate(Map<String, Element> records, Collection<HarvestError> errors) {
        records.entrySet().forEach(e -> {
            if (this.cancelMonitor.get()) {
                return;
            }
            try {
                String id = this.metadataUtils.getMetadataId((String)e.getKey());
                if (id == null) {
                    this.log.debug("Adding record with uuid " + (String)e.getKey());
                    this.addMetadata((Map.Entry<String, Element>)e, null);
                } else if (this.localUuids.getID((String)e.getKey()) == null) {
                    ++this.result.datasetUuidExist;
                    switch (((SimpleUrlParams)this.params).getOverrideUuid()) {
                        case OVERRIDE: {
                            this.updateMetadata((Map.Entry<String, Element>)e, Integer.toString(this.metadataUtils.findOneByUuid((String)e.getKey()).getId()), true);
                            this.log.debug("Overriding record with uuid " + (String)e.getKey());
                            ++this.result.updatedMetadata;
                            break;
                        }
                        case RANDOM: {
                            this.log.debug("Generating random uuid for remote record with uuid " + (String)e.getKey());
                            this.addMetadata((Map.Entry<String, Element>)e, UUID.randomUUID().toString());
                            break;
                        }
                        case SKIP: {
                            this.log.debug("Skipping record with uuid " + (String)e.getKey());
                            ++this.result.uuidSkipped;
                        }
                    }
                } else {
                    this.updateMetadata((Map.Entry<String, Element>)e, id, false);
                    if (((SimpleUrlParams)this.params).isIfRecordExistAppendPrivileges()) {
                        this.addPrivileges(id, ((SimpleUrlParams)this.params).getPrivileges(), this.localGroups, this.context);
                        ++this.result.privilegesAppendedOnExistingRecord;
                    }
                }
                ++this.result.totalMetadata;
            }
            catch (Throwable t) {
                errors.add(new HarvestError(this.context, t));
                this.log.error("Unable to process record from csw (" + ((SimpleUrlParams)this.params).getName() + ")");
                this.log.error("   Record failed: " + (String)e.getKey() + ". Error is: " + t.getMessage());
                this.log.error(t);
            }
            finally {
                ++this.result.originalMetadata;
            }
        });
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public HarvestResult cleanupRemovedRecords(Set<String> records) throws Exception {
        if (this.cancelMonitor.get()) {
            return this.result;
        }
        for (String uuid : this.localUuids.getUUIDs()) {
            if (records.contains(uuid)) continue;
            String id = this.localUuids.getID(uuid);
            this.log.debug("  - Removing old metadata with local id:" + id);
            this.metadataManager.deleteMetadata(this.context, id);
            ++this.result.locallyRemoved;
        }
        this.dataMan.forceIndexChanges();
        return this.result;
    }

    private void addMetadata(Map.Entry<String, Element> record, String overrideUuidValue) throws Exception {
        if (this.cancelMonitor.get()) {
            return;
        }
        Element xml = record.getValue();
        if (xml == null) {
            ++this.result.unretrievable;
            return;
        }
        String schema = this.dataMan.autodetectSchema(xml, null);
        if (schema == null) {
            this.log.debug("  - Metadata skipped due to unknown schema. uuid:" + record.getKey());
            ++this.result.unknownSchema;
            return;
        }
        String uuid = record.getKey();
        if (overrideUuidValue != null) {
            this.log.debug(String.format("  - Overriding UUID %s by %s", record.getKey(), overrideUuidValue));
            uuid = overrideUuidValue;
            xml = this.dataMan.setUUID(schema, uuid, record.getValue());
        }
        this.log.debug("  - Adding metadata with uuid:" + uuid + " schema:" + schema);
        String dateModified = this.dataMan.extractDateModified(schema, xml);
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        Integer ownerId = this.getOwner();
        metadata.getDataInfo().setSchemaId(schema).setRoot(xml.getQualifiedName()).setType(MetadataType.METADATA).setChangeDate(new ISODate(dateModified)).setCreateDate(new ISODate(dateModified));
        metadata.getSourceInfo().setSourceId(((SimpleUrlParams)this.params).getUuid()).setOwner(ownerId).setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((SimpleUrlParams)this.params).getUuid());
        metadata.getSourceInfo().setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        this.addCategories((AbstractMetadata)metadata, ((SimpleUrlParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, xml, false, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((SimpleUrlParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.metadataIndexer.indexMetadata(id, true);
        ++this.result.addedMetadata;
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    boolean updateMetadata(Map.Entry<String, Element> ri, String id, Boolean force) throws Exception {
        Element md = ri.getValue();
        if (md == null) {
            ++this.result.unchangedMetadata;
            return false;
        }
        boolean validate = false;
        boolean ufo = false;
        boolean index = false;
        String language = this.context.getLanguage();
        String schema = this.dataMan.autodetectSchema(md, null);
        String dateModified = this.dataMan.extractDateModified(schema, ri.getValue());
        AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, index, language, dateModified, true);
        if (force.booleanValue()) {
            metadata.getHarvestInfo().setUuid(((SimpleUrlParams)this.params).getUuid());
            metadata.getSourceInfo().setSourceId(((SimpleUrlParams)this.params).getUuid());
            this.metadataManager.save((AbstractMetadata)((Metadata)metadata));
        }
        OperationAllowedRepository repository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
        repository.deleteAllByMetadataId(Integer.parseInt(id));
        this.addPrivileges(id, ((SimpleUrlParams)this.params).getPrivileges(), this.localGroups, this.context);
        metadata.getCategories().clear();
        this.addCategories(metadata, ((SimpleUrlParams)this.params).getCategories(), this.localCateg, this.context, null, true);
        ++this.result.updatedMetadata;
        return true;
    }
}

