/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ohai.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;

@Singleton
public class NestSlashKeys
implements Function<Multimap<String, Supplier<JsonBall>>, Map<String, JsonBall>> {
    private final Json json;
    final Type mapLiteral = new TypeLiteral<Map<String, JsonBall>>(){}.getType();
    final Type listLiteral = new TypeLiteral<List<JsonBall>>(){}.getType();

    @Inject
    NestSlashKeys(Json json) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public Map<String, JsonBall> apply(Multimap<String, Supplier<JsonBall>> from) {
        Map<String, JsonBall> autoAttrs = this.mergeSameKeys(from);
        LinkedHashMap modifiableFlatMap = Maps.newLinkedHashMap((Map)Maps.filterKeys(autoAttrs, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.indexOf(47) == -1;
            }
        }));
        Map withSlashesMap = Maps.difference(autoAttrs, (Map)modifiableFlatMap).entriesOnlyOnLeft();
        for (Map.Entry entry : withSlashesMap.entrySet()) {
            ArrayList keyParts = Lists.newArrayList((Iterable)Splitter.on((char)'/').split((CharSequence)entry.getKey()));
            JsonBall toInsert = (JsonBall)entry.getValue();
            try {
                this.putUnderContext(keyParts, toInsert, modifiableFlatMap);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("error inserting value in entry: " + (String)entry.getKey(), e);
            }
        }
        return modifiableFlatMap;
    }

    private Map<String, JsonBall> mergeSameKeys(Multimap<String, Supplier<JsonBall>> from) {
        LinkedHashMap merged = Maps.newLinkedHashMap();
        for (Map.Entry entry : from.entries()) {
            if (merged.containsKey(entry.getKey())) {
                this.mergeAsPeer((String)entry.getKey(), (JsonBall)((Supplier)entry.getValue()).get(), merged);
                continue;
            }
            merged.put(entry.getKey(), ((Supplier)entry.getValue()).get());
        }
        return merged;
    }

    @VisibleForTesting
    void mergeAsPeer(String key, JsonBall value, Map<String, JsonBall> insertionContext) {
        Map immutableValueContext = (Map)this.json.fromJson(insertionContext.get(key).toString(), this.mapLiteral);
        LinkedHashMap valueContext = Maps.newLinkedHashMap((Map)immutableValueContext);
        Map toPut = (Map)this.json.fromJson(value.toString(), this.mapLiteral);
        Sets.SetView uniques = Sets.difference(toPut.keySet(), valueContext.keySet());
        for (String k : uniques) {
            valueContext.put(k, toPut.get(k));
        }
        Sets.SetView conflicts = Sets.difference(toPut.keySet(), (Set)uniques);
        for (String k : conflicts) {
            JsonBall v = (JsonBall)toPut.get(k);
            if (v.toString().matches("^\\{.*\\}$")) {
                this.mergeAsPeer(k, v, valueContext);
                continue;
            }
            valueContext.put(k, v);
        }
        insertionContext.put(key, new JsonBall(this.json.toJson((Object)valueContext, this.mapLiteral)));
    }

    void putUnderContext(List<String> keyParts, JsonBall toInsert, Map<String, JsonBall> destination) {
        Preconditions.checkNotNull(keyParts, (Object)"keyParts");
        Preconditions.checkArgument((keyParts.size() >= 1 ? 1 : 0) != 0, (Object)"keyParts must contain at least one element");
        Preconditions.checkNotNull((Object)toInsert, (Object)"toInsert");
        Preconditions.checkNotNull(destination, (Object)"destination");
        String rootKey = keyParts.remove(0);
        String rootValue = destination.containsKey(rootKey) ? destination.get(rootKey).toString() : "{}";
        Preconditions.checkArgument((boolean)rootValue.matches("^\\{.*\\}$"), (String)"value must be a hash: %s", (Object[])new Object[]{rootValue});
        Map immutableInsertionContext = (Map)this.json.fromJson(rootValue, this.mapLiteral);
        LinkedHashMap insertionContext = Maps.newLinkedHashMap((Map)immutableInsertionContext);
        if (keyParts.size() == 1) {
            if (!insertionContext.containsKey(keyParts.get(0))) {
                insertionContext.put(keyParts.get(0), toInsert);
            } else {
                String key = keyParts.get(0);
                this.mergeAsPeer(key, toInsert, insertionContext);
            }
        } else {
            this.putUnderContext(keyParts, toInsert, insertionContext);
        }
        destination.put(rootKey, new JsonBall(this.json.toJson((Object)insertionContext, this.mapLiteral)));
    }
}

