/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.config.ChefBootstrapModule;
import org.jclouds.chef.config.ChefHttpApiModule;
import org.jclouds.chef.config.ChefParserModule;
import org.jclouds.ohai.config.JMXOhaiModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class ChefApiMetadata
extends BaseHttpApiMetadata<ChefApi> {
    public static final String DEFAULT_API_VERSION = "12.0.2";

    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public ChefApiMetadata() {
        this(new Builder());
    }

    protected ChefApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.timeouts.default", TimeUnit.SECONDS.toMillis(30L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.updateCookbook", TimeUnit.MINUTES.toMillis(10L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.createClient", TimeUnit.MINUTES.toMillis(2L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.generateKeyForClient", TimeUnit.MINUTES.toMillis(2L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.createNode", TimeUnit.MINUTES.toMillis(2L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.updateNode", TimeUnit.MINUTES.toMillis(10L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.createRole", TimeUnit.MINUTES.toMillis(2L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.updateRole", TimeUnit.MINUTES.toMillis(10L) + "");
        properties.setProperty("jclouds.timeouts.ChefApi.createEnvironment", TimeUnit.MINUTES.toMillis(2L) + "");
        properties.setProperty("jclouds.session-interval", "1");
        properties.setProperty("chef.bootstrap-databag", "bootstrap");
        properties.setProperty("chef.update-gem-system", "false");
        properties.setProperty("chef.update-gems", "false");
        properties.setProperty("chef.use-omnibus", "true");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<ChefApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("chef")).name("Chef Api")).identityName("User")).credentialName("Certificate")).version(ChefApiMetadata.DEFAULT_API_VERSION)).documentation(URI.create("https://docs.chef.io/api_chef_server.html"))).defaultEndpoint("http://localhost:4000")).defaultProperties(ChefApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.of(ChefHttpApiModule.class, ChefParserModule.class, ChefBootstrapModule.class, JMXOhaiModule.class));
        }

        public ChefApiMetadata build() {
            return new ChefApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

