/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.config.Config;
import org.mapfish.print.config.layout.Layout;
import org.mapfish.print.utils.PJsonObject;

public class RenderingContext {
    private final Document document;
    private final PdfWriter writer;
    private final Config config;
    private final PJsonObject globalParams;
    private final String configDir;
    private final PDFCustomBlocks customBlocks;
    private final Layout layout;
    private final Map<String, String> headers;
    private final Map<String, Map<String, PJsonObject>> mergeableParams;
    private PJsonObject currentPageParams = null;
    private float styleFactor = 1.0f;
    private Map<URI, PdfTemplate> templateCache = Collections.synchronizedMap(new HashMap());
    private final Object pdfLock = new Object();

    public RenderingContext(Document document, PdfWriter writer, Config config, PJsonObject globalParams, String configDir, Layout layout, Map<String, String> headers) {
        this.document = document;
        this.writer = writer;
        this.config = config;
        this.globalParams = globalParams;
        this.mergeableParams = globalParams.has("mergeableParams") ? this.buildMergeableParams() : null;
        this.configDir = configDir;
        this.layout = layout;
        this.headers = headers;
        this.customBlocks = new PDFCustomBlocks(writer, this);
    }

    private Map<String, Map<String, PJsonObject>> buildMergeableParams() {
        HashMap<String, Map<String, PJsonObject>> result = new HashMap<String, Map<String, PJsonObject>>();
        PJsonObject mergeableParamsObj = this.globalParams.getJSONObject("mergeableParams");
        Iterator<String> mergeableParamsIt = mergeableParamsObj.keys();
        while (mergeableParamsIt.hasNext()) {
            String key = mergeableParamsIt.next();
            PJsonObject mergeableParam = mergeableParamsObj.getJSONObject(key);
            String context = mergeableParam.optString("context", "*");
            HashMap<String, PJsonObject> container = (HashMap<String, PJsonObject>)result.get(context.toUpperCase());
            if (container == null) {
                container = new HashMap<String, PJsonObject>();
            }
            container.put(key.toUpperCase(), mergeableParam);
            result.put(context.toUpperCase(), container);
        }
        return result;
    }

    public Map<String, PJsonObject> getMergeableParams(String context) {
        HashMap<String, PJsonObject> result = new HashMap<String, PJsonObject>();
        if (this.mergeableParams != null) {
            if (this.mergeableParams.containsKey(context.toUpperCase())) {
                result.putAll(this.mergeableParams.get(context.toUpperCase()));
            }
            if (this.mergeableParams.containsKey("*")) {
                result.putAll(this.mergeableParams.get("*"));
            }
        }
        return result;
    }

    public PDFCustomBlocks getCustomBlocks() {
        return this.customBlocks;
    }

    public Document getDocument() {
        return this.document;
    }

    public Config getConfig() {
        return this.config;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public PdfContentByte getDirectContent() {
        return this.writer.getDirectContent();
    }

    public PJsonObject getGlobalParams() {
        return this.globalParams;
    }

    public void setCurrentPageParams(PJsonObject pageParams) {
        this.currentPageParams = pageParams;
    }

    public PJsonObject getCurrentPageParams() {
        return this.currentPageParams;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void addError(Exception e) {
        this.customBlocks.addError(e);
    }

    public float getStyleFactor() {
        return this.styleFactor;
    }

    public void setStyleFactor(float styleFactor) {
        this.styleFactor = styleFactor;
    }

    public Map<URI, PdfTemplate> getTemplateCache() {
        return this.templateCache;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getPdfLock() {
        return this.pdfLock;
    }
}

