/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh.services;

import java.util.ArrayList;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.kernel.oaipmh.OaiPmhService;
import org.fao.geonet.kernel.oaipmh.ResumptionTokenCache;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.fao.oaipmh.exceptions.BadResumptionTokenException;
import org.fao.oaipmh.exceptions.NoRecordsMatchException;
import org.fao.oaipmh.requests.AbstractRequest;
import org.fao.oaipmh.requests.TokenListRequest;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.responses.GeonetworkResumptionToken;
import org.fao.oaipmh.responses.ListResponse;
import org.fao.oaipmh.responses.ResumptionToken;
import org.fao.oaipmh.util.SearchResult;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractTokenLister
implements OaiPmhService {
    protected ResumptionTokenCache cache;
    private SettingManager settingMan;
    private SchemaManager schemaMan;

    public AbstractTokenLister(ResumptionTokenCache cache, SettingManager sm, SchemaManager scm) {
        this.cache = cache;
        this.settingMan = sm;
        this.schemaMan = scm;
    }

    public int getMode() {
        return this.settingMan.getValueAsInt("system/oai/mdmode");
    }

    public int getMaxRecords() {
        return this.settingMan.getValueAsInt("system/oai/maxrecords");
    }

    public String getDateFrom() {
        String dateFrom = "dateFrom";
        if (this.getMode() == 1) {
            dateFrom = "extFrom";
        }
        return dateFrom;
    }

    public String getDateUntil() {
        String dateUntil = "dateTo";
        if (this.getMode() == 1) {
            dateUntil = "extTo";
        }
        return dateUntil;
    }

    @Override
    public AbstractResponse execute(AbstractRequest request, ServiceContext context) throws Exception {
        SearchResult result;
        if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
            Log.debug((String)"geonetwork.oai.provider", (Object)("OAI " + this.getClass().getSimpleName() + " execute: "));
        }
        TokenListRequest req = (TokenListRequest)request;
        String strToken = req.getResumptionToken();
        GeonetworkResumptionToken token = null;
        int pos = 0;
        if (strToken == null) {
            if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
                Log.debug((String)"geonetwork.oai.provider", (Object)("OAI " + this.getClass().getSimpleName() + " : new request (no resumptionToken)"));
            }
            Element params = new Element("request");
            ISODate from = req.getFrom();
            ISODate until = req.getUntil();
            String set = req.getSet();
            String prefix = req.getMetadataPrefix();
            if (from != null) {
                String sFrom = from.isDateOnly() ? from.getDateAsString() : from.toString();
                params.addContent((Content)new Element(this.getDateFrom()).setText(sFrom));
            }
            if (until != null) {
                String sTo = until.isDateOnly() ? until.getDateAsString() : until.toString();
                params.addContent((Content)new Element(this.getDateUntil()).setText(sTo));
            }
            if (from != null && until != null && from.timeDifferenceInSeconds(until) > 0L) {
                throw new BadArgumentException("From is greater than until");
            }
            if (set != null) {
                params.addContent((Content)new Element("category").setText(set));
            }
            params.addContent((Content)new Element("_schema").setText(prefix));
            result = new SearchResult(prefix);
            if (this.schemaMan.existsSchema(prefix)) {
                result.setIds(Lib.search(context, params));
            } else {
                List<String> schemas = this.getSchemasThatCanConvertTo(prefix);
                for (String schema : schemas) {
                    params.removeChild("_schema");
                    params.addContent((Content)new Element("_schema").setText(schema));
                    result.addIds(Lib.search(context, (Element)params.clone()));
                }
                if (schemas.size() == 0) {
                    result.setIds(new ArrayList());
                }
            }
            if (result.getIds().size() == 0) {
                throw new NoRecordsMatchException("No results");
            }
            if (result.getIds().size() > this.getMaxRecords()) {
                token = new GeonetworkResumptionToken(req, result);
                this.cache.storeResumptionToken(token);
            }
        } else {
            token = this.cache.getResumptionToken(GeonetworkResumptionToken.buildKey((TokenListRequest)req));
            if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
                Log.debug((String)"geonetwork.oai.provider", (Object)("OAI ListRecords : using ResumptionToken :" + GeonetworkResumptionToken.buildKey((TokenListRequest)req)));
            }
            if (token == null) {
                throw new BadResumptionTokenException("No session for token : " + GeonetworkResumptionToken.buildKey((TokenListRequest)req));
            }
            result = token.getRes();
            pos = GeonetworkResumptionToken.getPos((TokenListRequest)req);
        }
        ListResponse res = this.processRequest(req, pos, result, context);
        pos += res.getSize();
        if (token == null && res.getSize() == 0) {
            throw new NoRecordsMatchException("No results");
        }
        if (token != null) {
            token.setupToken(pos);
        }
        res.setResumptionToken((ResumptionToken)token);
        return res;
    }

    private List<String> getSchemasThatCanConvertTo(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String schema : this.schemaMan.getSchemas()) {
            if (!Lib.existsConverter(this.schemaMan.getSchemaDir(schema), prefix)) continue;
            result.add(schema);
        }
        return result;
    }

    @Override
    public abstract String getVerb();

    public abstract ListResponse processRequest(TokenListRequest var1, int var2, SearchResult var3, ServiceContext var4) throws Exception;
}

