/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.DoubleSetToSetAdapter;
import bak.pcj.adapter.LongCollectionToCollectionAdapter;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.DoubleKeyLongMap;
import bak.pcj.map.DoubleKeyLongMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DoubleKeyLongMapToMapAdapter
implements Map {
    protected DoubleKeyLongMap map;

    public DoubleKeyLongMapToMapAdapter(DoubleKeyLongMap map) throws NullPointerException {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) throws NullPointerException, ClassCastException {
        return this.map.containsKey((Double)key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.map.containsValue((Long)value);
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.map.size()) {
            return false;
        }
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getKey() == null) {
                return false;
            }
            if (e.getValue() == null) {
                return false;
            }
            if (this.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) throws NullPointerException, ClassCastException {
        double k = (Double)key;
        long v = this.map.get(k);
        if (v == MapDefaults.defaultLong() && !this.map.containsKey(k)) {
            return null;
        }
        return new Long(v);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return new DoubleSetToSetAdapter(this.map.keySet());
    }

    public Object put(Object key, Object value) throws NullPointerException, ClassCastException {
        Object result = this.get(key);
        double k = (Double)key;
        this.map.put(k, (Long)value);
        return result;
    }

    public void putAll(Map map) throws NullPointerException, ClassCastException {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        if (!(key instanceof Double)) {
            return null;
        }
        Object result = this.get(key);
        double k = (Double)key;
        this.map.remove(k);
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return new LongCollectionToCollectionAdapter(this.map.values());
    }

    class Entry
    implements Map.Entry {
        Double key;
        Long value;

        Entry(double key, long value) {
            this.key = new Double(key);
            this.value = new Long(value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return DoubleKeyLongMapToMapAdapter.this.put(this.key, value);
        }

        public int hashCode() {
            return DefaultDoubleHashFunction.INSTANCE.hash(this.key) ^ DefaultLongHashFunction.INSTANCE.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                DoubleKeyLongMapIterator i;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = EntrySet.access$000((EntrySet)this.this$1).map.entries();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    this.i.next();
                    return EntrySet.access$000(this.this$1).new Entry(this.i.getKey(), this.i.getValue());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean add(Object obj) {
            Map.Entry e = (Map.Entry)obj;
            if (this.contains(e)) {
                return false;
            }
            DoubleKeyLongMapToMapAdapter.this.put(e.getKey(), e.getValue());
            return true;
        }

        public int size() {
            return DoubleKeyLongMapToMapAdapter.this.map.size();
        }

        static /* synthetic */ DoubleKeyLongMapToMapAdapter access$000(EntrySet x0) {
            return x0.DoubleKeyLongMapToMapAdapter.this;
        }
    }
}

