/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.ByteCollection;
import bak.pcj.ByteIterator;
import bak.pcj.util.Exceptions;

public class SynchronizedByteCollection
implements ByteCollection {
    protected ByteCollection collection;
    protected Object m;

    public SynchronizedByteCollection(ByteCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = c;
        this.m = this;
    }

    public boolean add(byte v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.add(v);
            return bl;
        }
    }

    public boolean addAll(ByteCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.addAll(c);
            return bl;
        }
    }

    public void clear() {
        Object object = this.m;
        synchronized (object) {
            this.collection.clear();
        }
    }

    public boolean contains(byte v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.contains(v);
            return bl;
        }
    }

    public boolean containsAll(ByteCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.containsAll(c);
            return bl;
        }
    }

    public boolean equals(Object obj) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.equals(obj);
            return bl;
        }
    }

    public int hashCode() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.hashCode();
            return n;
        }
    }

    public boolean isEmpty() {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.isEmpty();
            return bl;
        }
    }

    public ByteIterator iterator() {
        Object object = this.m;
        synchronized (object) {
            ByteIterator byteIterator = this.collection.iterator();
            return byteIterator;
        }
    }

    public boolean remove(byte v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.remove(v);
            return bl;
        }
    }

    public boolean removeAll(ByteCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.removeAll(c);
            return bl;
        }
    }

    public boolean retainAll(ByteCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.retainAll(c);
            return bl;
        }
    }

    public int size() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.size();
            return n;
        }
    }

    public byte[] toArray() {
        Object object = this.m;
        synchronized (object) {
            byte[] byArray = this.collection.toArray();
            return byArray;
        }
    }

    public byte[] toArray(byte[] a) {
        Object object = this.m;
        synchronized (object) {
            byte[] byArray = this.collection.toArray(a);
            return byArray;
        }
    }

    public void trimToSize() {
        Object object = this.m;
        synchronized (object) {
            this.collection.trimToSize();
        }
    }
}

