/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public final class IndexedFeatureResults
extends DataFeatureCollection {
    STRtree index = new STRtree();
    Envelope bounds;
    int count;
    private Envelope queryBounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedFeatureResults(SimpleFeatureCollection results) throws IOException, IllegalAttributeException {
        super(null, (SimpleFeatureType)results.getSchema());
        SimpleFeatureIterator reader = null;
        this.bounds = new Envelope();
        this.count = 0;
        try {
            reader = results.features();
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                Envelope env = ((Geometry)f.getDefaultGeometry()).getEnvelopeInternal();
                this.bounds.expandToInclude(env);
                ++this.count;
                this.index.insert(env, (Object)f);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader(Envelope envelope) throws IOException {
        List results = this.index.query(envelope);
        final Iterator resultsIterator = results.iterator();
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){

            @Override
            public SimpleFeatureType getFeatureType() {
                return IndexedFeatureResults.this.getSchema();
            }

            @Override
            public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                return (SimpleFeature)resultsIterator.next();
            }

            @Override
            public boolean hasNext() throws IOException {
                return resultsIterator.hasNext();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference(this.bounds);
    }

    @Override
    public int getCount() throws IOException {
        return this.count;
    }

    public SimpleFeatureCollection collection() throws IOException {
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        List results = this.index.query(this.bounds);
        Iterator it = results.iterator();
        while (it.hasNext()) {
            fc.add((SimpleFeature)it.next());
        }
        return fc;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        if (this.queryBounds != null) {
            return this.reader(this.queryBounds);
        }
        return this.reader(this.bounds);
    }

    public void setQueryBounds(Envelope queryBounds) {
        this.queryBounds = queryBounds;
    }
}

