/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.awt.Color;
import java.util.List;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.GraphicBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.util.Converters;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Graphic;
import org.opengis.style.Stroke;

public class StrokeBuilder
extends AbstractStyleBuilder<org.geotools.styling.Stroke> {
    Expression color;
    Expression width;
    Expression opacity;
    Expression lineCap;
    Expression lineJoin;
    float[] dashArray = null;
    List<Expression> dashArrayExpressions = null;
    Expression dashOffset;
    GraphicBuilder graphicFill = new GraphicBuilder(this).unset();
    GraphicBuilder graphicStroke = new GraphicBuilder(this).unset();

    public StrokeBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public StrokeBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    @Override
    public StrokeBuilder unset() {
        return (StrokeBuilder)super.unset();
    }

    public StrokeBuilder reset() {
        this.color = org.geotools.styling.Stroke.DEFAULT.getColor();
        this.width = org.geotools.styling.Stroke.DEFAULT.getWidth();
        this.opacity = org.geotools.styling.Stroke.DEFAULT.getOpacity();
        this.lineCap = org.geotools.styling.Stroke.DEFAULT.getLineCap();
        this.lineJoin = org.geotools.styling.Stroke.DEFAULT.getLineJoin();
        this.dashArray = org.geotools.styling.Stroke.DEFAULT.getDashArray();
        this.dashArrayExpressions = org.geotools.styling.Stroke.DEFAULT.dashArray();
        this.dashOffset = org.geotools.styling.Stroke.DEFAULT.getDashOffset();
        this.graphicFill.unset();
        this.graphicStroke.unset();
        this.unset = false;
        return this;
    }

    public StrokeBuilder reset(org.geotools.styling.Stroke original) {
        return this.reset((Stroke)original);
    }

    public StrokeBuilder reset(Stroke stroke) {
        if (stroke == null) {
            return this.unset();
        }
        this.color = stroke.getColor();
        this.width = stroke.getWidth();
        this.opacity = stroke.getOpacity();
        this.lineCap = stroke.getLineCap();
        this.lineJoin = stroke.getLineJoin();
        this.dashArray = stroke.getDashArray();
        this.dashArrayExpressions = stroke instanceof org.geotools.styling.Stroke ? ((org.geotools.styling.Stroke)stroke).dashArray() : null;
        this.dashOffset = stroke.getDashOffset();
        this.graphicFill.reset((Graphic)stroke.getGraphicFill());
        this.graphicStroke.reset((Graphic)stroke.getGraphicStroke());
        this.unset = false;
        return this;
    }

    public StrokeBuilder color(Expression color) {
        this.unset = false;
        this.color = color;
        return this;
    }

    public StrokeBuilder color(Color color) {
        return this.color(this.literal(color));
    }

    public StrokeBuilder color(String cqlExpression) {
        return this.color(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder colorHex(String hex) {
        Color color = (Color)Converters.convert((Object)hex, Color.class);
        if (color == null) {
            throw new IllegalArgumentException("The provided expression could not be turned into a color: " + hex);
        }
        return this.color(color);
    }

    public StrokeBuilder width(Expression width) {
        this.unset = false;
        this.width = width;
        return this;
    }

    public StrokeBuilder width(double width) {
        return this.width(this.literal(width));
    }

    public StrokeBuilder width(String cqlExpression) {
        return this.width(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder opacity(Expression opacity) {
        this.unset = false;
        this.opacity = opacity;
        return this;
    }

    public StrokeBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public StrokeBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder lineCap(Expression lineCap) {
        this.unset = false;
        this.lineCap = lineCap;
        return this;
    }

    public StrokeBuilder lineCap(String cqlExpression) {
        return this.lineCap(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder lineCapName(String cap) {
        return this.lineCap(this.literal(cap));
    }

    public StrokeBuilder lineJoin(Expression lineJoin) {
        this.unset = false;
        this.lineJoin = lineJoin;
        return this;
    }

    public StrokeBuilder lineJoin(String cqlExpression) {
        return this.lineJoin(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder lineJoinName(String join) {
        return this.lineJoin(this.literal(join));
    }

    public StrokeBuilder dashArray(float ... dashArray) {
        this.dashArray = dashArray;
        this.unset = false;
        return this;
    }

    public StrokeBuilder dashArray(List<Expression> dashArrayExpressions) {
        this.dashArrayExpressions = dashArrayExpressions;
        return this;
    }

    public StrokeBuilder dashOffset(Expression dashOffset) {
        this.dashOffset = dashOffset;
        return this;
    }

    public StrokeBuilder dashOffset(double dashOffset) {
        return this.dashOffset(this.literal(dashOffset));
    }

    public StrokeBuilder dashOffset(String cqlExpression) {
        return this.dashOffset(this.cqlExpression(cqlExpression));
    }

    public GraphicBuilder graphicStroke() {
        this.unset = false;
        return this.graphicStroke;
    }

    public GraphicBuilder fillBuilder() {
        this.unset = false;
        return this.graphicFill;
    }

    @Override
    public org.geotools.styling.Stroke build() {
        if (this.unset) {
            return null;
        }
        org.geotools.styling.Stroke stroke = this.sf.createStroke(this.color, this.width, this.opacity, this.lineJoin, this.lineCap, this.dashArray, this.dashOffset, this.graphicFill.build(), this.graphicStroke.build());
        if (this.dashArrayExpressions != null && !this.dashArrayExpressions.isEmpty()) {
            stroke.setDashArray(this.dashArrayExpressions);
        }
        if (this.parent == null) {
            this.reset();
        }
        return stroke;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().line().stroke().init(this);
    }
}

