/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.entitylistener;

import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.entitylistener.GeonetworkEntityListener;
import org.fao.geonet.entitylistener.PersistentEventType;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.springframework.beans.factory.annotation.Autowired;

public class SettingValueSetter
implements GeonetworkEntityListener<Setting> {
    @Autowired
    private StandardPBEStringEncryptor encryptor;

    @Override
    public Class<Setting> getEntityClass() {
        return Setting.class;
    }

    @Override
    public void handleEvent(PersistentEventType type, Setting entity) {
        if (type == PersistentEventType.PrePersist) {
            if (entity.isEncrypted() && StringUtils.isNotEmpty((String)entity.getValue())) {
                entity.setStoredValue(this.encryptor.encrypt(entity.getValue()));
            } else {
                entity.setStoredValue(entity.getValue());
            }
        } else if (type == PersistentEventType.PreUpdate) {
            if (entity.isEncrypted() && StringUtils.isNotEmpty((String)entity.getValue())) {
                entity.setStoredValue(this.encryptor.encrypt(entity.getValue()));
            }
        } else if (type == PersistentEventType.PostLoad || type == PersistentEventType.PostUpdate) {
            if (entity.isEncrypted() && StringUtils.isNotEmpty((String)entity.getStoredValue())) {
                entity.setValue(this.encryptor.decrypt(entity.getStoredValue()));
            } else {
                entity.setValue(entity.getStoredValue());
            }
        }
    }
}

