/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.util.http.HttpServerUtil;

public class HTTPOutputStream
extends OutputStream {
    private HttpServletResponse _response;
    private OutputStream _responseStream;
    private boolean _streamOpened;
    private boolean _streamClosed;
    private String _contentType;
    private boolean _cacheable;
    private boolean _useGZIP;

    public HTTPOutputStream(HttpServletResponse response) {
        this(response, null);
    }

    public HTTPOutputStream(HttpServletResponse response, String contentType) {
        this._response = response;
        this._contentType = contentType;
        this._cacheable = true;
        this._useGZIP = false;
        this._streamOpened = false;
        this._streamClosed = false;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public void setCacheableResult(boolean cacheable) {
        this._cacheable = cacheable;
    }

    public void setUseGZIPCompression(boolean useGZIP) {
        this._useGZIP = useGZIP;
    }

    public void write(int b) throws IOException {
        this._ensureOpened();
        this._responseStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._ensureOpened();
        this._responseStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._ensureOpened();
        this._responseStream.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this._responseStream != null) {
            this._responseStream.flush();
            this._response.flushBuffer();
        }
    }

    public void close() throws IOException {
        if (!this._streamClosed) {
            this._ensureOpened();
            this._responseStream.close();
            this._response.flushBuffer();
            this._streamClosed = true;
        }
    }

    public boolean streamOpened() {
        return this._streamOpened;
    }

    public boolean streamClosed() {
        return this._streamClosed;
    }

    private void _ensureOpened() throws IOException {
        if (this._streamClosed) {
            throw new IOException("OutputStream has already been closed");
        }
        if (!this._streamOpened) {
            this._response.setContentType(this._contentType);
            if (!this._cacheable) {
                HttpServerUtil.setNoCacheHeaders((HttpServletResponse)this._response);
            }
            this._response.setStatus(200);
            this._responseStream = this._useGZIP ? HttpServerUtil.openGZIPOutputStream((HttpServletResponse)this._response) : this._response.getOutputStream();
            this._streamOpened = true;
        }
    }
}

