/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;

public class MockXmlRequest
extends XmlRequest {
    private Set<Predicate<HttpRequestBase>> _unaccessed = new HashSet<Predicate<HttpRequestBase>>();
    private Map<Predicate<HttpRequestBase>, Callable<ClientHttpResponse>> _mapping = new LinkedHashMap<Predicate<HttpRequestBase>, Callable<ClientHttpResponse>>();

    public MockXmlRequest(String host, int port, String protocol) {
        super(host, port, protocol, null);
    }

    @Override
    protected ClientHttpResponse doExecute(HttpRequestBase httpMethod) throws IOException {
        for (Map.Entry<Predicate<HttpRequestBase>, Callable<ClientHttpResponse>> entry : this._mapping.entrySet()) {
            if (!entry.getKey().apply((Object)httpMethod)) continue;
            try {
                this._unaccessed.remove(entry.getKey());
                return entry.getValue().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException(httpMethod + " is not have a mapped request");
    }

    public MockXmlRequestWithWhen when(String path) {
        return new MockXmlRequestWithWhen(path);
    }

    public MockXmlRequestWithWhen when(Predicate<HttpRequestBase> predicate) {
        return new MockXmlRequestWithWhen(predicate);
    }

    public List<String> getUnaccessedRequests() {
        ArrayList<String> missed = new ArrayList<String>();
        for (Predicate<HttpRequestBase> predicate : this._unaccessed) {
            missed.add(predicate.toString());
        }
        return missed;
    }

    public class MockXmlRequestWithWhen {
        private final Predicate<HttpRequestBase> _predicate;

        private MockXmlRequestWithWhen(String path) {
            this._predicate = new PathMatchingPredicate(path);
        }

        public MockXmlRequestWithWhen(Predicate<HttpRequestBase> predicate) {
            this._predicate = predicate;
        }

        public MockXmlRequest thenReturn(InputStream response) {
            try {
                return this.thenReturn(Xml.loadStream(response));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public MockXmlRequest thenReturn(final Element response) {
            return this.thenReturn(new Callable<ClientHttpResponse>(){

                @Override
                public ClientHttpResponse call() throws Exception {
                    return new MockClientHttpResponse(Xml.getString(response).getBytes("UTF-8"), HttpStatus.OK);
                }
            });
        }

        public MockXmlRequest thenReturn(Callable<ClientHttpResponse> response) {
            MockXmlRequest.this._mapping.put(this._predicate, response);
            MockXmlRequest.this._unaccessed.add(this._predicate);
            return MockXmlRequest.this;
        }
    }

    private static class PathMatchingPredicate
    implements Predicate<HttpRequestBase> {
        private final String _path;

        public PathMatchingPredicate(String path) {
            this._path = path;
        }

        public boolean apply(@Nullable HttpRequestBase input) {
            if (input == null) {
                return false;
            }
            URI uri = input.getURI();
            boolean equalPath = uri.toString().equalsIgnoreCase(this._path);
            return input instanceof HttpGet && equalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathMatchingPredicate that = (PathMatchingPredicate)o;
            return !(this._path != null ? !this._path.equals(that._path) : that._path != null);
        }

        public int hashCode() {
            return this._path != null ? this._path.hashCode() : 0;
        }
    }
}

