/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import jeeves.component.ProfileManager;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.ldap.AbstractLDAPUserDetailsContextMapper;
import org.fao.geonet.utils.Log;
import org.springframework.util.StringUtils;

public class LDAPUserDetailsContextMapperWithProfileSearch
extends AbstractLDAPUserDetailsContextMapper {
    private String groupAttribute;
    private String groupObject;
    private String groupQuery;
    private String groupQueryPattern;
    private String privilegeAttribute;
    private String privilegeObject;
    private String privilegeQuery;
    private String privilegeQueryPattern;
    private String privilegePattern;
    private Pattern pattern = null;
    private int groupIndexInPattern;
    private int profilIndexInPattern;
    private Pattern groupQueryPatternCompiled;
    private Pattern privilegeQueryPatternCompiled;

    @Override
    protected void setProfilesAndPrivileges(Profile defaultProfile, String defaultGroup, Map<String, ArrayList<String>> userInfo, LDAPUser userDetails) {
        if (!StringUtils.isEmpty((Object)this.groupQuery)) {
            if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                StringBuffer sb = new StringBuffer("Group and profile search:");
                sb.append("\nGroup attribute: \t" + this.groupAttribute);
                sb.append("\nGroup query: \t" + this.groupQuery);
                sb.append("\nGroup query pattern: \t" + this.groupQueryPattern);
                sb.append("\nProfile attribute: \t" + this.privilegeAttribute);
                sb.append("\nProfile query: \t" + this.privilegeQuery);
                sb.append("\nProfile attribute: \t" + this.privilegeQueryPattern);
                Log.debug((String)"geonetwork.ldap", (Object)sb.toString());
            }
            try {
                DirContext dc = this.contextSource.getReadOnlyContext();
                HashSet<Profile> profileList = new HashSet<Profile>();
                String groupsQuery = MessageFormat.format(this.privilegeQuery, userDetails.getUsername());
                NamingEnumeration<SearchResult> ldapInfoList = dc.search(this.privilegeObject, groupsQuery, null);
                while (ldapInfoList.hasMore()) {
                    SearchResult sr = ldapInfoList.next();
                    String profileName = (String)sr.getAttributes().get(this.privilegeAttribute).get();
                    Matcher m = this.privilegeQueryPatternCompiled.matcher(profileName);
                    boolean b = m.matches();
                    if (b) {
                        Profile p = Profile.findProfileIgnoreCase((String)m.group(1));
                        if (p == null) {
                            Profile mapped;
                            Log.debug((String)"geonetwork.ldap", (Object)("profile is null " + this.getClass() + ".setProfilesAndPrivileges()"));
                            if (this.profileMapping != null && (mapped = (Profile)this.profileMapping.get(m.group(1))) != null) {
                                p = mapped;
                                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                                    Log.debug((String)"geonetwork.ldap", (Object)("ldap profileName is " + profileName + ", pattern matched " + m.group(1) + " adding profile " + p.name()));
                                }
                            }
                        }
                        if (p == null) continue;
                        profileList.add(p);
                        continue;
                    }
                    Log.error((String)"geonetwork.ldap", (Object)("LDAP profile '" + profileName + "' does not match search pattern '" + this.privilegeQueryPattern + "'. Information ignored."));
                }
                Profile highestUserProfile = ProfileManager.getHighestProfile(profileList.toArray(new Profile[profileList.size()]));
                if (highestUserProfile != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  Highest user profile is " + highestUserProfile));
                    }
                    userDetails.getUser().setProfile(highestUserProfile);
                }
                if (userDetails.getUser().getProfile() == null) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  No profile defined in LDAP, using default profile " + defaultProfile));
                    }
                    userDetails.getUser().setProfile(defaultProfile);
                }
                String groupQuery = MessageFormat.format(this.groupQuery, userDetails.getUsername());
                ldapInfoList = dc.search(this.groupObject, groupQuery, null);
                while (ldapInfoList.hasMore()) {
                    String group;
                    Matcher m;
                    SearchResult sr = ldapInfoList.next();
                    String groupName = (String)sr.getAttributes().get(this.groupAttribute).get();
                    if (this.pattern != null) {
                        m = this.pattern.matcher(groupName);
                        if (m.matches()) {
                            String group2 = m.group(this.groupIndexInPattern);
                            Profile profile = null;
                            if (this.profilIndexInPattern > 0) {
                                profile = Profile.findProfileIgnoreCase((String)m.group(this.profilIndexInPattern));
                            }
                            if (profile != null) {
                                if (!"ALL".equals(group2)) {
                                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                                        Log.debug((String)"geonetwork.ldap", (Object)("  Adding profile " + profile + " for group " + group2));
                                    }
                                    userDetails.addPrivilege(group2, profile);
                                    profileList.add(profile);
                                    continue;
                                }
                                profileList.add(profile);
                                continue;
                            }
                            userDetails.addPrivilege(group2, userDetails.getUser().getProfile());
                            continue;
                        }
                        Matcher m2 = this.groupQueryPatternCompiled.matcher(groupName);
                        if (m2.matches()) {
                            group = m2.group(1);
                            userDetails.addPrivilege(group, userDetails.getUser().getProfile());
                            continue;
                        }
                        Log.error((String)"geonetwork.ldap", (Object)("LDAP group '" + groupName + "' does not match search pattern '" + this.groupQueryPattern + "'. Information ignored."));
                        continue;
                    }
                    m = this.groupQueryPatternCompiled.matcher(groupName);
                    boolean b = m.matches();
                    if (b) {
                        group = m.group(1);
                        userDetails.addPrivilege(group, userDetails.getUser().getProfile());
                        continue;
                    }
                    Log.error((String)"geonetwork.ldap", (Object)("LDAP group '" + groupName + "' does not match search pattern '" + this.groupQueryPattern + "'. Information ignored."));
                }
                highestUserProfile = ProfileManager.getHighestProfile(profileList.toArray(new Profile[profileList.size()]));
                if (highestUserProfile != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  Highest user profile is " + highestUserProfile));
                    }
                    userDetails.getUser().setProfile(highestUserProfile);
                }
                if (userDetails.getUser().getProfile() == null) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  No profile defined in LDAP, using default profile " + defaultProfile));
                    }
                    userDetails.getUser().setProfile(defaultProfile);
                }
            }
            catch (NamingException e) {
                Log.error((String)"geonetwork.ldap", (Object)("Failed to extract profiles and groups. Error is: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getGroupQuery() {
        return this.groupQuery;
    }

    public void setGroupQuery(String groupQuery) {
        this.groupQuery = groupQuery;
    }

    public String getGroupQueryPattern() {
        return this.groupQueryPattern;
    }

    public void setGroupQueryPattern(String groupQueryPattern) {
        this.groupQueryPattern = groupQueryPattern;
        this.groupQueryPatternCompiled = Pattern.compile(groupQueryPattern);
    }

    public String getPrivilegeQuery() {
        return this.privilegeQuery;
    }

    public void setPrivilegeQuery(String privilegeQuery) {
        this.privilegeQuery = privilegeQuery;
    }

    public String getPrivilegeQueryPattern() {
        return this.privilegeQueryPattern;
    }

    public void setPrivilegeQueryPattern(String privilegeQueryPattern) {
        this.privilegeQueryPattern = privilegeQueryPattern;
        this.privilegeQueryPatternCompiled = Pattern.compile(privilegeQueryPattern);
    }

    public String getGroupObject() {
        return this.groupObject;
    }

    public void setGroupObject(String groupObject) {
        this.groupObject = groupObject;
    }

    public String getPrivilegeObject() {
        return this.privilegeObject;
    }

    public void setPrivilegeObject(String privilegeObject) {
        this.privilegeObject = privilegeObject;
    }

    public String getGroupAttribute() {
        return this.groupAttribute;
    }

    public void setGroupAttribute(String groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public String getPrivilegeAttribute() {
        return this.privilegeAttribute;
    }

    public void setPrivilegeAttribute(String privilegeAttribute) {
        this.privilegeAttribute = privilegeAttribute;
    }

    public String getPrivilegePattern() {
        return this.privilegePattern;
    }

    public void setPrivilegePattern(String privilegePattern) {
        this.privilegePattern = privilegePattern;
        this.pattern = Pattern.compile(privilegePattern);
    }

    public int getGroupIndexInPattern() {
        return this.groupIndexInPattern;
    }

    public void setGroupIndexInPattern(int groupIndexInPattern) {
        this.groupIndexInPattern = groupIndexInPattern;
    }

    public int getProfilIndexInPattern() {
        return this.profilIndexInPattern;
    }

    public void setProfilIndexInPattern(int profilIndexInPattern) {
        this.profilIndexInPattern = profilIndexInPattern;
    }
}

