/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;
import org.jdom.xpath.XPath;
import org.springframework.context.ApplicationContext;

public class SchemaUtils {
    public Element addSchema(ServiceContext context, String schema, String fname, URL url, String uuid, SchemaManager scm) throws Exception {
        return this.processSchema(context, schema, fname, url, uuid, scm, true);
    }

    public Element updateSchema(ServiceContext context, String schema, String fname, URL url, String uuid, SchemaManager scm) throws Exception {
        return this.processSchema(context, schema, fname, url, uuid, scm, false);
    }

    private Element processSchema(ServiceContext context, String schema, String fname, URL url, String uuid, SchemaManager scm, boolean add) throws Exception {
        Path zipArchive;
        boolean deleteTempZip = false;
        if (!"".equals(uuid)) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            DataManager dm = gc.getBean(DataManager.class);
            String id = dm.getMetadataId(uuid.toLowerCase());
            if (id == null) {
                throw new OperationAbortedEx("Metadata record with uuid " + uuid + " doesn't exist");
            }
            try {
                Lib.resource.checkPrivilege(context, id, ReservedOperation.download);
            }
            catch (Exception e) {
                throw new OperationAbortedEx("Download access not available on metadata record with uuid " + uuid);
            }
            boolean forEditing = false;
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            Element elMd = dm.getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
            if (elMd == null) {
                throw new OperationAbortedEx("Metadata record " + uuid + " doesn't exist");
            }
            Element elBrief = dm.extractSummary(elMd);
            XPath xp = XPath.newInstance((String)"link[contains(@protocol,'metadata-schema')]");
            List elems = xp.selectNodes((Object)elBrief);
            try {
                url = this.getMetadataSchemaUrl(elems);
            }
            catch (MalformedURLException mu) {
                throw new OperationAbortedEx("Metadata schema URL link for metadata record " + uuid + " is malformed : " + mu.getMessage());
            }
            if (url == null) {
                throw new OperationAbortedEx("Unable to find metadata schema URL link for metadata record " + uuid);
            }
        }
        if (url != null) {
            XmlRequest strReq = context.getBean(GeonetHttpRequestFactory.class).createXmlRequest(url);
            zipArchive = Files.createTempDirectory("schema", new FileAttribute[0]);
            deleteTempZip = true;
            strReq.executeLarge(zipArchive);
        } else {
            zipArchive = IO.toPath((String)fname, (String[])new String[0]);
        }
        Element response = this.doSchema(context, scm, schema, zipArchive, add);
        if (deleteTempZip) {
            IO.deleteFile((Path)zipArchive, (boolean)false, (String)"geonetwork.schemamanager");
        }
        return response;
    }

    private Element doSchema(ServiceContext context, SchemaManager scm, String schema, Path zipArchive, boolean add) throws Exception {
        Element response = new Element("response");
        if (!Files.exists(zipArchive, new LinkOption[0])) {
            throw new OperationAbortedEx("Zip Archive doesn't exist");
        }
        long fsize = Files.size(zipArchive);
        if (fsize == 0L) {
            throw new OperationAbortedEx("Schema archive has zero size");
        }
        try (FileSystem zipFs = ZipUtil.openZipFs((Path)zipArchive);){
            if (add) {
                scm.addPluginSchema((ApplicationContext)context.getApplicationContext(), schema, zipFs);
            } else {
                scm.updatePluginSchema((ApplicationContext)context.getApplicationContext(), schema, zipFs);
            }
            response.setAttribute("status", "ok");
            response.setAttribute("message", "Schema " + schema + " has been added/updated");
        }
        catch (Exception e) {
            throw new OperationAbortedEx("Schema add/update failed: " + e.getMessage(), (Object)e);
        }
        return response;
    }

    private URL getMetadataSchemaUrl(List<?> elems) throws MalformedURLException {
        for (Object ob : elems) {
            if (!(ob instanceof Element)) continue;
            Element elem = (Element)ob;
            String href = elem.getAttributeValue("href");
            return new URL(href);
        }
        return null;
    }
}

