/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.utils.PubliclyCloneable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArraysUtils {
    public static <T> T[] asArray(T ... args) {
        return args;
    }

    public static <T> Set<T> asSet(T ... args) {
        return new HashSet<T>(Arrays.asList(args));
    }

    public static <T> int count(Collection<T> collection, Filter<T> filter) {
        int result = 0;
        for (T t : collection) {
            if (!filter.accept(t)) continue;
            ++result;
        }
        return result;
    }

    public static <T> List<T> sameLengthSuffix(List<T> ofList, List<T> asThis) {
        if (asThis.size() > ofList.size()) {
            return null;
        }
        int to = ofList.size();
        int from = to - asThis.size();
        return ofList.subList(from, to);
    }

    public static <T> List<T> sameLengthPrefix(List<T> ofList, List<T> asThis) {
        if (asThis.size() > ofList.size()) {
            return null;
        }
        return ofList.subList(0, asThis.size());
    }

    public static <T> List<T> sublistWithoutLast(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.subList(0, values.size() - 1);
    }

    public static <T> List<T> sublistWithoutFirst(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.subList(1, values.size());
    }

    public static <T> List<T> safeSublist(List<T> values, int from, int to) {
        if (values.isEmpty()) {
            return null;
        }
        if (from > to) {
            return new ArrayList();
        }
        if (from > values.size()) {
            from = values.size();
        }
        if (to > values.size()) {
            to = values.size();
        }
        return values.subList(from, to);
    }

    public static <T> T last(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    public static <T> T chopLast(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.remove(values.size() - 1);
    }

    public static <T> T first(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public static <T> T chopFirst(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.remove(0);
    }

    public static <T> List<T> chopUpTo(List<T> list, T exclusiveTo) {
        int indx = list.indexOf(exclusiveTo);
        if (indx == -1) {
            return new ArrayList();
        }
        List<T> subList = list.subList(0, indx);
        ArrayList<T> result = new ArrayList<T>(subList);
        subList.clear();
        return result;
    }

    public static <T> List<T> chopPrefix(List<T> list, int exclusiveTo) {
        if (exclusiveTo > list.size()) {
            exclusiveTo = list.size();
        }
        List<T> subList = list.subList(0, exclusiveTo);
        ArrayList<T> result = new ArrayList<T>(subList);
        subList.clear();
        return result;
    }

    public static <T> List<T> asNonNullList(T ... a) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : a) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> addIfNonNull(List<T> destination, T ... a) {
        for (T t : a) {
            if (t == null) continue;
            destination.add(t);
        }
        return destination;
    }

    public static <T extends PubliclyCloneable> List<T> deeplyClonedList(List<T> list) {
        ArrayList<PubliclyCloneable> result = new ArrayList<PubliclyCloneable>();
        for (PubliclyCloneable t : list) {
            result.add(t.clone());
        }
        return result;
    }

    public static <T extends PubliclyCloneable> LinkedList<T> deeplyClonedLinkedList(LinkedList<T> list) {
        LinkedList<PubliclyCloneable> result = new LinkedList<PubliclyCloneable>();
        for (PubliclyCloneable t : list) {
            result.add(t.clone());
        }
        return result;
    }

    public static <M, T extends PubliclyCloneable> Map<M, T> deeplyClonedMap(Map<M, T> map) {
        HashMap<M, PubliclyCloneable> result = new HashMap<M, PubliclyCloneable>();
        for (Map.Entry<M, T> t : map.entrySet()) {
            result.put(t.getKey(), ((PubliclyCloneable)t.getValue()).clone());
        }
        return result;
    }

    public static <M, T extends PubliclyCloneable> Map<M, List<T>> deeplyClonedListInMap(Map<M, List<T>> map) {
        HashMap<M, List<T>> result = new HashMap<M, List<T>>();
        for (Map.Entry<M, List<T>> t : map.entrySet()) {
            result.put(t.getKey(), ArraysUtils.deeplyClonedList(t.getValue()));
        }
        return result;
    }

    public static <T> List<T> remaining(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T> List<T> asModifiableList(T ... head) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : head) {
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> joinAll(List<T> ... lists) {
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> t : lists) {
            result.addAll(t);
        }
        return result;
    }

    public static <T> void replace(SelectorPart lookFor, List<T> inside, List<T> replaceBy) {
        int indx = inside.indexOf(lookFor);
        inside.remove(lookFor);
        inside.addAll(indx, replaceBy);
    }

    public static boolean isUtf8(byte[] input) {
        return ArraysUtils.isEncodedAs(input, "UTF-8");
    }

    public static boolean isUsAscii(byte[] input) {
        return ArraysUtils.isEncodedAs(input, "US-ASCII");
    }

    public static boolean isEncodedAs(byte[] input, String encoding) {
        CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            decoder.decode(ByteBuffer.wrap(input));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    public static <Q> void replace(List<Q> inList, Q oldElement, LinkedList<Q> newElements) {
        int level = inList.indexOf(oldElement);
        inList.remove(level);
        inList.addAll(level, newElements);
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

