/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.editing;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.guiservices.session.Get;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.XmlFile;
import jeeves.services.ReadWriteController;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.records.editing.AjaxEditUtils;
import org.fao.geonet.api.records.model.Direction;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.events.history.RecordUpdatedEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataStatus;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordEditing")
@PreAuthorize(value="hasAuthority('Editor')")
@ReadWriteController
public class MetadataEditingApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    MetadataDraftRepository metadataDraftRepository;

    @Operation(summary="Edit a record", description="Return HTML form for editing.")
    @RequestMapping(value={"/{metadataUuid}/editor"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The editor form."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    public void startEditing(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Tab") @RequestParam(defaultValue="simple") String currTab, @RequestParam(defaultValue="false") boolean withAttributes, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IMetadataUtils dm;
        Integer id2;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        boolean showValidationErrors = false;
        ServiceContext context = ApiUtils.createServiceContext(request);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean isEnabledWorkflow = sm.getValueAsBool("metadata/workflow/enable");
        boolean flagCreateDraftFromApprovedMetadata = false;
        if (isEnabledWorkflow) {
            boolean bl = flagCreateDraftFromApprovedMetadata = this.metadataDraftRepository.findOneByUuid(metadata.getUuid()) == null;
        }
        if ((id2 = (dm = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class)).startEditingSession(context, String.valueOf(metadata.getId()))).intValue() != metadata.getId()) {
            StringBuilder sb = new StringBuilder("?");
            Enumeration parameters = request.getParameterNames();
            boolean hasPreviousURL = false;
            while (parameters.hasMoreElements()) {
                String key = (String)parameters.nextElement();
                sb.append(key + "=" + request.getParameter(key) + "%26");
                if (!key.equalsIgnoreCase("redirectUrl")) continue;
                hasPreviousURL = true;
            }
            if (!hasPreviousURL) {
                sb.append("redirectUrl=catalog.edit");
            }
            context.getUserSession().setProperty("metadata.editing.created.draft", (Object)flagCreateDraftFromApprovedMetadata);
            Element el = new Element("script");
            el.setText("window.location.hash = decodeURIComponent(\"#/metadata/" + id2 + sb.toString() + "\")");
            String elStr = Xml.getString((Element)el);
            response.getWriter().print(elStr);
            return;
        }
        Element elMd = new AjaxEditUtils(context).getMetadataEmbedded(context, String.valueOf(metadata.getId()), true, showValidationErrors);
        this.buildEditorForm(currTab, session, allRequestParams, request, elMd, metadata.getDataInfo().getSchemaId(), context, (ApplicationContext)applicationContext, false, false, response);
    }

    @Operation(summary="Save edits", description="Save the HTML form content.")
    @RequestMapping(value={"/{metadataUuid}/editor"}, method={RequestMethod.POST}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The editor form."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void saveEdits(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Tab") @RequestParam(defaultValue="simple") String tab, @RequestParam(defaultValue="false") boolean withAttributes, @RequestParam(defaultValue="false") boolean withValidationErrors, @RequestParam(defaultValue="false") boolean minor, @Parameter(description="Submit for review directly after save.") @RequestParam(defaultValue="1") String status, @Parameter(description="Save current edits.") @RequestParam(defaultValue="false") boolean commit, @Parameter(description="Save and terminate session.") @RequestParam(defaultValue="false") boolean terminate, @Parameter(description="Record as XML. TODO: rename xml") @RequestParam(defaultValue="") String data, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        Log.trace((String)"geonetwork.datamanager", (Object)("Saving metadata editing with UUID " + metadataUuid));
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        AjaxEditUtils ajaxEditUtils = new AjaxEditUtils(context);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        DataManager dataMan = (DataManager)applicationContext.getBean(DataManager.class);
        UserSession session = ApiUtils.getUserSession(httpSession);
        IMetadataValidator validator = (IMetadataValidator)applicationContext.getBean(IMetadataValidator.class);
        BaseMetadataStatus statusRepository = (BaseMetadataStatus)ApplicationContextHolder.get().getBean(BaseMetadataStatus.class);
        String id = String.valueOf(metadata.getId());
        Log.trace((String)"geonetwork.datamanager", (Object)(" > ID of the record to edit: " + id));
        String isTemplate = allRequestParams.get("template");
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean isEditor = session.getProfile().equals((Object)Profile.Editor);
        boolean isReviewer = session.getProfile().equals((Object)Profile.Reviewer);
        boolean isAdmin = session.getProfile().equals((Object)Profile.Administrator);
        boolean isEnabledWorkflow = sm.getValueAsBool("metadata/workflow/enable");
        if (isEnabledWorkflow && isEditor && !statusRepository.canEditorEdit(Integer.valueOf(metadata.getId()))) {
            throw new NotAllowedException("Editing is allowed only in Draft state for the current profile.");
        }
        Log.trace((String)"geonetwork.datamanager", (Object)" > Getting parameters from request");
        Element params = new Element("request");
        HashMap<String, String> forwardedParams = new HashMap<String, String>();
        for (Map.Entry<String, String> e : allRequestParams.entrySet()) {
            params.addContent((Content)new Element(e.getKey()).setText(e.getValue()));
            if (e.getKey().startsWith("_")) continue;
            forwardedParams.put(e.getKey(), e.getValue());
        }
        if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
            Log.trace((String)"geonetwork.datamanager", (Object)(" > Setting type of record " + MetadataType.lookup((String)isTemplate)));
        }
        int iLocalId = Integer.parseInt(id);
        Log.trace((String)"geonetwork.datamanager", (Object)(" > Id is " + iLocalId));
        dataMan.setTemplateExt(iLocalId, MetadataType.lookup((String)isTemplate));
        Log.trace((String)"geonetwork.datamanager", (Object)" > Trigger status actions based on this edit");
        StatusActionsFactory saf = (StatusActionsFactory)context.getBean(StatusActionsFactory.class);
        StatusActions sa = saf.createStatusActions(context);
        sa.onEdit(iLocalId, minor);
        Element beforeMetadata = dataMan.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
        if (StringUtils.isNotEmpty((String)data)) {
            Log.trace((String)"geonetwork.datamanager", (Object)" > Updating metadata through data manager");
            Element md = Xml.loadString((String)data, (boolean)false);
            String changeDate = null;
            boolean updateDateStamp = !minor;
            boolean ufo = true;
            boolean index = true;
            dataMan.updateMetadata(context, id, md, withValidationErrors, ufo, index, context.getLanguage(), changeDate, updateDateStamp);
            if (terminate) {
                XMLOutputter outp = new XMLOutputter();
                String xmlBefore = outp.outputString(beforeMetadata);
                String xmlAfter = outp.outputString(md);
                new RecordUpdatedEvent(Long.valueOf(Long.parseLong(id)), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter).publish((ApplicationContext)applicationContext);
            }
        } else {
            Log.trace((String)"geonetwork.datamanager", (Object)" > Updating contents");
            ajaxEditUtils.updateContent(params, false, true);
            Element afterMetadata = dataMan.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
            if (terminate) {
                XMLOutputter outp = new XMLOutputter();
                String xmlBefore = outp.outputString(beforeMetadata);
                String xmlAfter = outp.outputString(afterMetadata);
                new RecordUpdatedEvent(Long.valueOf(Long.parseLong(id)), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter).publish((ApplicationContext)applicationContext);
            }
        }
        if (commit && !terminate) {
            return;
        }
        if (terminate) {
            Metadata metadataApproved;
            Log.trace((String)"geonetwork.datamanager", (Object)" > Closing editor");
            boolean forceValidationOnMdSave = sm.getValueAsBool("metadata/workflow/forceValidationOnMdSave");
            boolean reindex = false;
            if (forceValidationOnMdSave) {
                validator.doValidate(metadata, context.getLanguage());
                reindex = true;
            }
            if (isEnabledWorkflow) {
                if (status.equals("4")) {
                    if (isEditor || isAdmin) {
                        Integer changeToStatus = Integer.parseInt("4");
                        statusRepository.changeCurrentStatus(Integer.valueOf(session.getUserIdAsInt()), Integer.valueOf(metadata.getId()), changeToStatus);
                    } else {
                        throw new SecurityException(String.format("Only users with editor profile can submit.", new Object[0]));
                    }
                }
                if (status.equals("2")) {
                    if (isReviewer || isAdmin) {
                        Integer changeToStatus = Integer.parseInt("2");
                        statusRepository.changeCurrentStatus(Integer.valueOf(session.getUserIdAsInt()), Integer.valueOf(metadata.getId()), changeToStatus);
                    } else {
                        throw new SecurityException(String.format("Only users with review profile can approve.", new Object[0]));
                    }
                }
            }
            boolean automaticUnpublishInvalidMd = sm.getValueAsBool("metadata/workflow/automaticUnpublishInvalidMd");
            boolean isUnpublished = false;
            if (automaticUnpublishInvalidMd) {
                boolean isPublic;
                OperationAllowedRepository operationAllowedRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
                boolean bl = isPublic = operationAllowedRepo.count(Specification.where((Specification)OperationAllowedSpecs.hasMetadataId((String)id)).and(OperationAllowedSpecs.hasOperation((ReservedOperation)ReservedOperation.view)).and(OperationAllowedSpecs.hasGroupId((int)ReservedGroup.all.getId()))) > 0L;
                if (isPublic) {
                    boolean isInvalid;
                    MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
                    boolean bl2 = isInvalid = metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)Integer.parseInt(id))) > 0L;
                    if (isInvalid) {
                        isUnpublished = true;
                        operationAllowedRepo.deleteAll(Specification.where((Specification)OperationAllowedSpecs.hasMetadataId((String)id)).and(OperationAllowedSpecs.hasGroupId((int)ReservedGroup.all.getId())));
                    }
                    reindex = true;
                }
            }
            if (reindex) {
                Log.trace((String)"geonetwork.datamanager", (Object)" > Reindexing record");
                dataMan.indexMetadata(id, true);
            }
            if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                this.metadataIndexer.indexMetadata(String.valueOf(metadataApproved.getId()), true);
            }
            ajaxEditUtils.removeMetadataEmbedded(session, id);
            dataMan.endEditingSession(id, session);
            if (isUnpublished) {
                throw new IllegalStateException(String.format("Record saved but as it was invalid at the end of the editing session. The public record '%s' was unpublished.", metadata.getUuid()));
            }
            return;
        }
        Element elMd = new AjaxEditUtils(context).getMetadataEmbedded(context, id, true, withValidationErrors);
        this.buildEditorForm(tab, httpSession, forwardedParams, request, elMd, metadata.getDataInfo().getSchemaId(), context, (ApplicationContext)applicationContext, false, false, response);
        if (isEnabledWorkflow) {
            context.getUserSession().removeProperty("metadata.editing.created.draft");
        }
    }

    @Operation(summary="Cancel edits", description="Cancel current editing session.")
    @RequestMapping(value={"/{metadataUuid}/editor"}, method={RequestMethod.DELETE}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Editing session cancelled."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void cancelEdits(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        DataManager dataMan = (DataManager)applicationContext.getBean(DataManager.class);
        ServiceContext context = ApiUtils.createServiceContext(request);
        dataMan.cancelEditingSession(context, String.valueOf(metadata.getId()));
    }

    @Operation(summary="Add element", description="")
    @RequestMapping(value={"/{metadataUuid}/editor/elements"}, method={RequestMethod.PUT}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Element added."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    public void addElement(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Reference of the insertion point.", required=true) @RequestParam String ref, @Parameter(description="Name of the element to add (with prefix)", required=true) @RequestParam String name, @Parameter(description="Use geonet:attribute for attributes or child name.", required=false) @RequestParam(required=false) String child, @Parameter(description="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Element elResp = new AjaxEditUtils(context).addElementEmbedded(ApiUtils.getUserSession(httpSession), String.valueOf(metadata.getId()), ref, name, child);
        EditLib.tagForDisplay((Element)elResp);
        Element md = (Element)this.findRoot(elResp).clone();
        EditLib.removeDisplayTag((Element)elResp);
        this.buildEditorForm(allRequestParams.get("currTab"), httpSession, allRequestParams, request, md, metadata.getDataInfo().getSchemaId(), context, (ApplicationContext)applicationContext, true, true, response);
    }

    @Operation(summary="Reorder element", description="")
    @RequestMapping(value={"/{metadataUuid}/editor/elements/{direction}"}, method={RequestMethod.PUT}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Element reordered."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void addElement(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Reference of the element to move.", required=true) @RequestParam String ref, @Parameter(description="Direction", required=true) @PathVariable Direction direction, @Parameter(description="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        new AjaxEditUtils(context).swapElementEmbedded(ApiUtils.getUserSession(httpSession), String.valueOf(metadata.getId()), ref, direction == Direction.down);
    }

    @Operation(summary="Delete element", description="")
    @RequestMapping(value={"/{metadataUuid}/editor/elements"}, method={RequestMethod.DELETE}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Element removed."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void deleteElement(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Reference of the element to remove.", required=true) @RequestParam String[] ref, @Parameter(description="Name of the parent.", required=true) @RequestParam String parent, @Parameter(description="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, HttpServletRequest request, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        String id = String.valueOf(metadata.getId());
        for (int i = 0; i < ref.length; ++i) {
            new AjaxEditUtils(context).deleteElementEmbedded(ApiUtils.getUserSession(httpSession), id, ref[i], parent);
        }
    }

    @Operation(summary="Delete attribute", description="")
    @RequestMapping(value={"/{metadataUuid}/editor/attributes"}, method={RequestMethod.DELETE}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Attribute removed."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void deleteAttribute(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Reference of the attribute to remove.", required=true) @RequestParam String ref, @Parameter(description="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, HttpServletRequest request, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        new AjaxEditUtils(context).deleteAttributeEmbedded(ApiUtils.getUserSession(httpSession), String.valueOf(metadata.getId()), ref);
    }

    private Element findRoot(Element element) {
        if (element.isRootElement() || element.getParentElement() == null) {
            return element;
        }
        return this.findRoot(element.getParentElement());
    }

    private void buildEditorForm(String tab, HttpSession session, Map<String, String> allRequestParams, HttpServletRequest request, Element xml, String schema, ServiceContext context, ApplicationContext applicationContext, boolean isEmbedded, boolean embedded, HttpServletResponse response) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        Element root = this.buildResourceDocument(applicationContext, context, userSession);
        root.addContent((Content)xml);
        Element gui = root.getChild("gui");
        gui.addContent((Content)new Element("currTab").setText(tab));
        gui.addContent((Content)new Element("reqService").setText(embedded ? "embedded" : "md.edit"));
        String iso3langCode = this.languageUtils.getIso3langCode(request.getLocales());
        gui.addContent((Content)new Element("language").setText(iso3langCode));
        gui.addContent((Content)this.getSchemaStrings(schema, context));
        Element requestParams = new Element("request");
        for (Map.Entry<String, String> e : allRequestParams.entrySet()) {
            requestParams.addContent((Content)new Element(e.getKey()).setText(e.getValue()));
        }
        root.addContent((Content)requestParams);
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        Path xslt = dataDirectory.getWebappDir().resolve(isEmbedded ? "xslt/ui-metadata/edit/edit-embedded.xsl" : "xslt/ui-metadata/edit/edit.xsl");
        Xml.transformXml((Element)root, (Path)xslt, (OutputStream)response.getOutputStream());
    }

    private Element buildResourceDocument(ApplicationContext applicationContext, ServiceContext context, UserSession userSession) throws JDOMException, SQLException, IOException {
        Element root = new Element("root");
        Element gui = new Element("gui");
        gui.addContent((Content)((SettingManager)applicationContext.getBean(SettingManager.class)).getAllAsXML(true));
        gui.addContent((Content)Get.getSessionAsXML((UserSession)userSession));
        ThesaurusManager th = (ThesaurusManager)applicationContext.getBean(ThesaurusManager.class);
        gui.addContent((Content)new Element("thesaurus").addContent((Content)th.buildResultfromThTable(context)));
        root.addContent((Content)gui);
        return root;
    }

    public Element getSchemaStrings(String schemaToLoad, ServiceContext context) throws Exception {
        Element schemas = new Element("schemas");
        for (String schema : this.schemaManager.getSchemas()) {
            if (!schema.equals(schemaToLoad) && !schemaToLoad.startsWith(schema) && !this.schemaManager.getDependencies(schemaToLoad).contains(schema)) continue;
            try {
                Map schemaInfo = this.schemaManager.getSchemaInfo(schema);
                for (Map.Entry entry : schemaInfo.entrySet()) {
                    XmlFile xf = (XmlFile)entry.getValue();
                    String fname = (String)entry.getKey();
                    Element response = xf.exec(new Element("junk"), context);
                    response.setName(FilenameUtils.removeExtension((String)fname));
                    response.removeAttribute("noNamespaceSchemaLocation", Geonet.Namespaces.XSI);
                    Element schemaElem = new Element(schema);
                    schemaElem.addContent((Content)response);
                    schemas.addContent((Content)schemaElem);
                }
            }
            catch (Exception e) {
                context.error("Failed to load localization file for schema " + schema + ": " + e.getMessage());
                context.error((Throwable)e);
            }
        }
        return schemas;
    }
}

