/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;
import org.springframework.security.ldap.userdetails.Person;

public class InetOrgPerson
extends Person {
    private static final long serialVersionUID = 520L;
    private String carLicense;
    private String destinationIndicator;
    private String departmentNumber;
    private String displayName;
    private String employeeNumber;
    private String homePhone;
    private String homePostalAddress;
    private String initials;
    private String mail;
    private String mobile;
    private String o;
    private String ou;
    private String postalAddress;
    private String postalCode;
    private String roomNumber;
    private String street;
    private String title;
    private String uid;

    public String getUid() {
        return this.uid;
    }

    public String getMail() {
        return this.mail;
    }

    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public String getInitials() {
        return this.initials;
    }

    public String getDestinationIndicator() {
        return this.destinationIndicator;
    }

    public String getO() {
        return this.o;
    }

    public String getOu() {
        return this.ou;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCarLicense() {
        return this.carLicense;
    }

    public String getDepartmentNumber() {
        return this.departmentNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHomePhone() {
        return this.homePhone;
    }

    public String getRoomNumber() {
        return this.roomNumber;
    }

    public String getHomePostalAddress() {
        return this.homePostalAddress;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getPostalAddress() {
        return this.postalAddress;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getStreet() {
        return this.street;
    }

    @Override
    protected void populateContext(DirContextAdapter adapter) {
        super.populateContext(adapter);
        adapter.setAttributeValue("carLicense", (Object)this.carLicense);
        adapter.setAttributeValue("departmentNumber", (Object)this.departmentNumber);
        adapter.setAttributeValue("destinationIndicator", (Object)this.destinationIndicator);
        adapter.setAttributeValue("displayName", (Object)this.displayName);
        adapter.setAttributeValue("employeeNumber", (Object)this.employeeNumber);
        adapter.setAttributeValue("homePhone", (Object)this.homePhone);
        adapter.setAttributeValue("homePostalAddress", (Object)this.homePostalAddress);
        adapter.setAttributeValue("initials", (Object)this.initials);
        adapter.setAttributeValue("mail", (Object)this.mail);
        adapter.setAttributeValue("mobile", (Object)this.mobile);
        adapter.setAttributeValue("postalAddress", (Object)this.postalAddress);
        adapter.setAttributeValue("postalCode", (Object)this.postalCode);
        adapter.setAttributeValue("ou", (Object)this.ou);
        adapter.setAttributeValue("o", (Object)this.o);
        adapter.setAttributeValue("roomNumber", (Object)this.roomNumber);
        adapter.setAttributeValue("street", (Object)this.street);
        adapter.setAttributeValue("uid", (Object)this.uid);
        adapter.setAttributeValues("objectclass", (Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
    }

    public static class Essence
    extends Person.Essence {
        public Essence() {
        }

        public Essence(InetOrgPerson copyMe) {
            super(copyMe);
            this.setCarLicense(copyMe.getCarLicense());
            this.setDepartmentNumber(copyMe.getDepartmentNumber());
            this.setDestinationIndicator(copyMe.getDestinationIndicator());
            this.setDisplayName(copyMe.getDisplayName());
            this.setEmployeeNumber(copyMe.getEmployeeNumber());
            this.setHomePhone(copyMe.getHomePhone());
            this.setHomePostalAddress(copyMe.getHomePostalAddress());
            this.setInitials(copyMe.getInitials());
            this.setMail(copyMe.getMail());
            this.setMobile(copyMe.getMobile());
            this.setO(copyMe.getO());
            this.setOu(copyMe.getOu());
            this.setPostalAddress(copyMe.getPostalAddress());
            this.setPostalCode(copyMe.getPostalCode());
            this.setRoomNumber(copyMe.getRoomNumber());
            this.setStreet(copyMe.getStreet());
            this.setTitle(copyMe.getTitle());
            this.setUid(copyMe.getUid());
        }

        public Essence(DirContextOperations ctx) {
            super(ctx);
            this.setCarLicense(ctx.getStringAttribute("carLicense"));
            this.setDepartmentNumber(ctx.getStringAttribute("departmentNumber"));
            this.setDestinationIndicator(ctx.getStringAttribute("destinationIndicator"));
            this.setDisplayName(ctx.getStringAttribute("displayName"));
            this.setEmployeeNumber(ctx.getStringAttribute("employeeNumber"));
            this.setHomePhone(ctx.getStringAttribute("homePhone"));
            this.setHomePostalAddress(ctx.getStringAttribute("homePostalAddress"));
            this.setInitials(ctx.getStringAttribute("initials"));
            this.setMail(ctx.getStringAttribute("mail"));
            this.setMobile(ctx.getStringAttribute("mobile"));
            this.setO(ctx.getStringAttribute("o"));
            this.setOu(ctx.getStringAttribute("ou"));
            this.setPostalAddress(ctx.getStringAttribute("postalAddress"));
            this.setPostalCode(ctx.getStringAttribute("postalCode"));
            this.setRoomNumber(ctx.getStringAttribute("roomNumber"));
            this.setStreet(ctx.getStringAttribute("street"));
            this.setTitle(ctx.getStringAttribute("title"));
            this.setUid(ctx.getStringAttribute("uid"));
        }

        @Override
        protected LdapUserDetailsImpl createTarget() {
            return new InetOrgPerson();
        }

        public void setMail(String email) {
            ((InetOrgPerson)this.instance).mail = email;
        }

        public void setUid(String uid) {
            ((InetOrgPerson)this.instance).uid = uid;
            if (this.instance.getUsername() == null) {
                this.setUsername(uid);
            }
        }

        public void setInitials(String initials) {
            ((InetOrgPerson)this.instance).initials = initials;
        }

        public void setO(String organization) {
            ((InetOrgPerson)this.instance).o = organization;
        }

        public void setOu(String ou) {
            ((InetOrgPerson)this.instance).ou = ou;
        }

        public void setRoomNumber(String no) {
            ((InetOrgPerson)this.instance).roomNumber = no;
        }

        public void setTitle(String title) {
            ((InetOrgPerson)this.instance).title = title;
        }

        public void setCarLicense(String carLicense) {
            ((InetOrgPerson)this.instance).carLicense = carLicense;
        }

        public void setDepartmentNumber(String departmentNumber) {
            ((InetOrgPerson)this.instance).departmentNumber = departmentNumber;
        }

        public void setDisplayName(String displayName) {
            ((InetOrgPerson)this.instance).displayName = displayName;
        }

        public void setEmployeeNumber(String no) {
            ((InetOrgPerson)this.instance).employeeNumber = no;
        }

        public void setDestinationIndicator(String destination) {
            ((InetOrgPerson)this.instance).destinationIndicator = destination;
        }

        public void setHomePhone(String homePhone) {
            ((InetOrgPerson)this.instance).homePhone = homePhone;
        }

        public void setStreet(String street) {
            ((InetOrgPerson)this.instance).street = street;
        }

        public void setPostalCode(String postalCode) {
            ((InetOrgPerson)this.instance).postalCode = postalCode;
        }

        public void setPostalAddress(String postalAddress) {
            ((InetOrgPerson)this.instance).postalAddress = postalAddress;
        }

        public void setMobile(String mobile) {
            ((InetOrgPerson)this.instance).mobile = mobile;
        }

        public void setHomePostalAddress(String homePostalAddress) {
            ((InetOrgPerson)this.instance).homePostalAddress = homePostalAddress;
        }
    }
}

