/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.LongIterator;
import bak.pcj.adapter.IteratorToLongIteratorAdapter;
import bak.pcj.set.AbstractLongSet;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToLongSetAdapter
extends AbstractLongSet
implements LongSet {
    protected Set set;

    public SetToLongSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToLongSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(long v) {
        return this.set.add(new Long(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(long v) {
        return this.set.contains(new Long(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public LongIterator iterator() {
        return new IteratorToLongIteratorAdapter(this.set.iterator());
    }

    public boolean remove(long v) {
        return this.set.remove(new Long(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isLongAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

