/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.referencing.operation.builder.Polygon;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;
import org.opengis.geometry.DirectPosition;

class Quadrilateral
extends Polygon {
    public DirectPosition p0;
    public DirectPosition p1;
    public DirectPosition p2;
    public DirectPosition p3;

    public Quadrilateral(DirectPosition p0, DirectPosition p1, DirectPosition p2, DirectPosition p3) {
        super(new DirectPosition[]{p0, p1, p2, p3, p0});
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    public boolean isConvex() {
        return Line2D.linesIntersect(this.p0.getCoordinate()[0], this.p0.getCoordinate()[1], this.p2.getCoordinate()[0], this.p2.getCoordinate()[1], this.p1.getCoordinate()[0], this.p1.getCoordinate()[1], this.p3.getCoordinate()[0], this.p3.getCoordinate()[1]);
    }

    public List<TINTriangle> getTriangles() {
        ArrayList<TINTriangle> triangles = new ArrayList<TINTriangle>();
        TINTriangle trigA = new TINTriangle(this.p0, this.p1, this.p2);
        TINTriangle trigB = new TINTriangle(this.p0, this.p3, this.p2);
        try {
            trigA.addAdjacentTriangle(trigB);
            trigB.addAdjacentTriangle(trigA);
        }
        catch (TriangulationException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        triangles.add(trigA);
        triangles.add(trigB);
        return triangles;
    }
}

